/*
    This file is part of libtdepim.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "myconfig.h"

#include <tdeconfigwizard.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>

#include <tqlayout.h>
#include <tqcheckbox.h>

class TestConfigWizard : public TDEConfigWizard
{
  public:
    TestConfigWizard() :
      TDEConfigWizard( new TDEConfigPropagator( MyConfig::self(),
                                            "propagator_test.kcfg" ) )
    {
      TQFrame *page = createWizardPage( "My Wizard Page" );
      TQBoxLayout *topLayout = new TQVBoxLayout( page );
      
      mFixKMailCheckBox = new TQCheckBox( i18n("Fix KMail"), page );      
      topLayout->addWidget( mFixKMailCheckBox );

      mFixKMailCheckBox->setChecked( MyConfig::fixKMail() );
    
      mBreakKMailCheckBox = new TQCheckBox( i18n("Break KMail"), page );      
      topLayout->addWidget( mBreakKMailCheckBox );

      mBreakKMailCheckBox->setChecked( MyConfig::breakKMail() );
    
      setupRulesPage();
      setupChangesPage();
    }
    
    ~TestConfigWizard()
    {
    }

    void usrReadConfig()
    {
    }

    void usrWriteConfig()
    {
      MyConfig::self()->setFixKMail( mFixKMailCheckBox->isChecked() );
      MyConfig::self()->setBreakKMail( mBreakKMailCheckBox->isChecked() );
    }

  private:
    TQCheckBox *mFixKMailCheckBox;
    TQCheckBox *mBreakKMailCheckBox;
};

static const TDECmdLineOptions options[] =
{
  {"verbose", "Verbose output", 0},
  TDECmdLineLastOption
};

int main(int argc,char **argv)
{
  TDEAboutData aboutData("testwizard","Test TDEConfigWizard","0.1");
  TDECmdLineArgs::init(argc,argv,&aboutData);
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  bool verbose = false;
  if ( args->isSet( "verbose" ) ) verbose = true;

  TestConfigWizard wizard;
  
  wizard.exec();
}
