/*
    passphrasedialog.cpp

    This file is part of libkleopatra, the KDE keymanagement library
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.


    Based on kpgpui.cpp
    Copyright (C) 2001,2002 the KPGP authors
    See file libtdenetwork/AUTHORS.kpgp for details

    This file is part of KPGP, the KDE PGP/GnuPG support library.

    KPGP is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

#ifndef HAVE_CONFIG_H
#include <config.h>
#endif

#include "passphrasedialog.h"

#include <kpassdlg.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqfontmetrics.h>

struct Kleo::PassphraseDialog::Private {
  KPasswordEdit * lineedit;
};


Kleo::PassphraseDialog::PassphraseDialog( const TQString & msg, const TQString & caption,
					  TQWidget * parent, const char * name, bool modal )
  : KDialogBase( parent, name, modal, caption, Ok|Cancel, Ok ), d( 0 )
{
  d = new Private();

  TQWidget * w = new TQWidget( this );
  setMainWidget( w );

  TQHBoxLayout * hlay = new TQHBoxLayout( w, 0, spacingHint() );

  TQLabel * label = new TQLabel( w );
  label->setPixmap( DesktopIcon( "pgp-keys", TDEIcon::SizeMedium ) );
  hlay->addWidget( label, 0, AlignTop );

  TQVBoxLayout * vlay = new TQVBoxLayout( hlay ); // inherits spacing

  vlay->addWidget( new TQLabel( msg.isEmpty() ? i18n("Please enter your passphrase:") : msg, w ) );

  d->lineedit = new KPasswordEdit( KPasswordEdit::OneStar, w, "d->lineedit" );
  d->lineedit->setMinimumWidth( fontMetrics().width("*") * 20 );
  d->lineedit->setFocus();

  vlay->addWidget( d->lineedit );

  connect( d->lineedit, TQ_SIGNAL(returnPressed()), TQ_SLOT(slotOk()) );

  disableResize();
}


Kleo::PassphraseDialog::~PassphraseDialog() {
  delete d; d = 0;
}

TQString Kleo::PassphraseDialog::passphrase() const {
  return d->lineedit->password();
}

void Kleo::PassphraseDialog::slotOk() {
  emit finished( passphrase() );
  KDialogBase::slotOk();
}

void Kleo::PassphraseDialog::slotCancel() {
  emit canceled();
  KDialogBase::slotCancel();
}

  
void Kleo::PassphraseDialog::virtual_hook( int id, void * data ) {
  return KDialogBase::virtual_hook( id, data );
}

#include "passphrasedialog.moc"
