/*
    This file is part of KAddressBook.
    Copyright (c) 2005 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef PRINTSORTMODE_H
#define PRINTSORTMODE_H

#include <tdeversion.h>

#if KDE_IS_VERSION(3,3,91)

#include <tdeabc/sortmode.h>

class PrintSortMode : public TDEABC::SortMode
{
  public:
    PrintSortMode( TDEABC::Field *field, bool ascending = true );

    virtual bool lesser( const TDEABC::Addressee&, const TDEABC::Addressee& ) const;

  private:
    TDEABC::Field *mSortField;
    TDEABC::Field *mGivenNameField;
    TDEABC::Field *mFamilyNameField;
    TDEABC::Field *mFormattedNameField;
    bool mAscending;
};

#endif // KDE_IS_VERSION

#endif // PRINTSORTMODE_H
