/*
    partnodebodypart.cpp

    This file is part of KMail, the KDE mail client.
    Copyright (c) 2004 Marc Mutz <mutz@kde.org>,
                       Ingo Kloecker <kloecker@kde.org>

    KMail is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#include "partnodebodypart.h"

#include "partNode.h"

#include <tqstring.h>
#include <tqcstring.h>

static int serial = 0;

KMail::PartNodeBodyPart::PartNodeBodyPart( partNode & n, const TQTextCodec * codec  )
  : KMail::Interface::BodyPart(), mPartNode( n ), mCodec( codec ),
    mDefaultDisplay( KMail::Interface::BodyPart::None )
{}

TQString KMail::PartNodeBodyPart::makeLink( const TQString & path ) const {
  static const int utf8 = 106;
  // FIXME: use a PRNG for the first arg, instead of a serial number
  return TQString( "x-kmail:/bodypart/%1/%2/%3" )
    .arg( serial++ ).arg( mPartNode.nodeId() )
    .arg( KURL::encode_string_no_slash( path, utf8 ) );
}

TQString KMail::PartNodeBodyPart::asText() const {
  if ( mPartNode.type() != DwMime::kTypeText )
    return TQString();
  return mPartNode.msgPart().bodyToUnicode( mCodec );
}

TQByteArray KMail::PartNodeBodyPart::asBinary() const {
  return mPartNode.msgPart().bodyDecodedBinary();
}

TQString KMail::PartNodeBodyPart::contentTypeParameter( const char * param ) const {
  return mPartNode.contentTypeParameter( param );
}

TQString KMail::PartNodeBodyPart::contentDescription() const {
  return mPartNode.msgPart().contentDescription();
}

TQString KMail::PartNodeBodyPart::contentDispositionParameter( const char * ) const {
  kdWarning( 5006 ) << "Sorry, not yet implemented: PartNodeBodyPart::contentDispositionParameter()" << endl;
  return TQString();
}

bool KMail::PartNodeBodyPart::hasCompleteBody() const {
  kdWarning( 5006 ) << "Sorry, not yet implemented: PartNodeBodyPart::contentDispositionParameter()" << endl;
  return true;
}

KMail::Interface::BodyPartMemento * KMail::PartNodeBodyPart::memento() const {
  return mPartNode.bodyPartMemento( "__plugin__" );
}

void KMail::PartNodeBodyPart::setBodyPartMemento( Interface::BodyPartMemento * memento ) {
  mPartNode.setBodyPartMemento( "__plugin__", memento );
}

KMail::Interface::BodyPart::Display KMail::PartNodeBodyPart::defaultDisplay() const {
  return mDefaultDisplay;
}

void KMail::PartNodeBodyPart::setDefaultDisplay( KMail::Interface::BodyPart::Display d ){
  mDefaultDisplay = d;
}
