/*
    This file is part of libkpimexchange
    Copyright (c) 2002 Jan-Pascal van Best <janpascal@vanbest.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcombobox.h>

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <tdeglobal.h>
#include <tdeconfig.h>
#include <tdestandarddirs.h>
#include <tdesimpleconfig.h>

#include "exchangeprogress.h"
using namespace KPIM;

ExchangeProgress::ExchangeProgress(TQWidget *parent)
  : KProgressDialog(parent, "", i18n("Exchange Download Progress"), i18n("Exchange Plugin"), "text" )
{
  m_finished = 0;
  m_total = 0;  
  setAutoClose( false );
  setLabel( i18n( "Listing appointments" ) );
}

ExchangeProgress::~ExchangeProgress()
{
}

void ExchangeProgress::slotTransferStarted()
{
  m_total++;
  progressBar()->setTotalSteps( m_total );
  updateLabel();
}

void ExchangeProgress::slotTransferFinished()
{
  m_finished++;
  updateLabel();
  if ( m_finished == m_total ) {
    emit complete( this );
  }
}

void ExchangeProgress::updateLabel()
{
  progressBar()->setValue( m_finished );
  TQString str = i18n( "Downloading, %1 of %2" ).arg( m_finished ).arg( m_total );
  setLabel( str );
}

#include "exchangeprogress.moc"
