/*
 * spellingfilter.h
 *
 * Copyright (c) 2002 Dave Corrie <kde@davecorrie.com>
 *
 *  This file is part of KMail.
 *
 *  KMail is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SPELLINGFILTER_H_INCLUDED
#define SPELLINGFILTER_H_INCLUDED

#include <tqstring.h>
#include <tqstringlist.h>
#include "linklocator.h"

#include <tdemacros.h>

class TDE_EXPORT SpellingFilter
{
public:
  enum UrlFiltering { DontFilterUrls, FilterUrls };
  enum EmailAddressFiltering { DontFilterEmailAddresses, FilterEmailAddresses };

  SpellingFilter(const TQString& text, const TQString& quotePrefix,
    UrlFiltering filterUrls = FilterUrls,
    EmailAddressFiltering filterEmailAddresses = FilterEmailAddresses,
    const TQStringList& filterStrings = TQStringList());

  TQString originalText() const;
  TQString filteredText() const;

  class TextCensor;

private:
  const TQString mOriginal;
  TQString mFiltered;
};

class SpellingFilter::TextCensor : public LinkLocator
{
public:
  TextCensor(const TQString& s);

  void censorQuotations(const TQString& quotePrefix);
  void censorUrls();
  void censorEmailAddresses();
  void censorString(const TQString& s);

  TQString censoredText() const;

private:
  bool atLineStart() const;
  void skipLine();

  bool atQuotation(const TQString& quotePrefix) const;
  void skipQuotation(const TQString& quotePrefix);
  void findQuotation(const TQString& quotePrefix);

  void findEmailAddress();
};

#endif // SPELLINGFILTER_H_INCLUDED

