
#ifndef _K_SSL_SOCKET_H_
#define _K_SSL_SOCKET_H_

/*
    ksslsocket.h - KDE SSL Socket

    Copyright (c) 2004      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqvariant.h>
#include <kextsock.h>
#include <tdeio/slavebase.h>

class KSSLSocketPrivate;

class KSSLSocket : public KExtendedSocket
{
	TQ_OBJECT
  

	public:
		KSSLSocket();
		~KSSLSocket();

		TQ_LONG readBlock( char* data, TQ_ULONG maxLen );
		TQ_LONG writeBlock( const char* data, TQ_ULONG len );

	signals:
		void sslFailure();

	private slots:
		void slotConnected();
		void slotDisconnected();

	private:
		int verifyCertificate();
		int messageBox( TDEIO::SlaveBase::MessageBoxType type, const TQString &text,
			const TQString &caption,	const TQString &buttonYes, const TQString &buttonNo );


		//Copied frm tcpslavebase to simply integrating their dialog function
		void setMetaData( const TQString &, const TQVariant & );
		bool hasMetaData( const TQString & );
		TQString metaData( const TQString & );

		KSSLSocketPrivate *d;
};

#endif
