/***************************************************************************
                          ringbuffer.h  -  description
                             -------------------
    begin                : Sun March 21 2004
    copyright            : (C) 2004 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KRADIO_FILE_RING_BUFFER_H
#define _KRADIO_FILE_RING_BUFFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstring.h>
#include <tdemacros.h>
#include <stdio.h>

class TDE_EXPORT FileRingBuffer
{
public:
    FileRingBuffer(const TQString &filename, TQ_UINT64 max_size);
    ~FileRingBuffer();

    bool       resize(const TQString &filename, TQ_UINT64 new_max_size);

    size_t     addData (const char *src, size_t size);
    size_t     takeData(char *dst, size_t size);
    TQ_UINT64   removeData(TQ_UINT64 size);

    const TQString &getFileName () const { return m_FileName; }
    TQ_UINT64       getMaxSize()   const { return m_MaxSize;  }
    TQ_UINT64       getRealSize()  const { return m_RealSize; }
    TQ_UINT64       getFillSize()  const { return m_FillSize; }
    TQ_UINT64       getFreeSize()  const { return (m_Start + m_FillSize > m_RealSize) ? m_RealSize - m_FillSize : m_MaxSize - m_FillSize; }

    void       clear();

    bool           error()       const { return m_error; }
    const TQString &errorString() const { return m_errorString; }

protected:
    TQ_UINT64    getFreeSpace(TQ_UINT64 &size);  // returns position in file + size
    TQ_UINT64    removeFreeSpace(TQ_UINT64 size);

    TQ_UINT64    getData(TQ_UINT64 &size);  // returns position in file + size


    int        m_FileIdx;
    TQString    m_BaseFileName;
    TQString    m_FileName;
    FILE      *m_File;
    TQ_UINT64   m_Start;
    TQ_UINT64   m_MaxSize;
    TQ_UINT64   m_RealSize;
    TQ_UINT64   m_FillSize;

    TQString   m_errorString;
    bool      m_error;
};

#endif
