/***************************************************************************
                          radiostation-listview.h  -  description
                             -------------------
    begin                : Mi Mar 03 2004
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef _KRADIO_RADIOSTATION_LISTVIEW_H_
#define _KRADIO_RADIOSTATION_LISTVIEW_H_

#include <tdelistview.h>

class RadioStation;
class StationList;

class TDE_EXPORT RadioStationListView : public TDEListView
{
TQ_OBJECT

public:
    RadioStationListView(TQWidget *parent=0, const char *name=0);
    virtual ~RadioStationListView();

    TQListViewItem *getItemForIndex(int idx) const;
    int            getIndexForItem(TQListViewItem *) const;

    void setStation(int idx, const RadioStation &, int nr = -1);
    void appendStation(const RadioStation &, int nr = -1);
    void setStations(const StationList &);

    void removeStation(int idx);
    void takeItem(TQListViewItem *item, int idx);
    void insertItem(TQListViewItem *item, const TQString &stationid, int idx);

    void setCurrentStation(int idx);
    int  currentStationIndex() const;

    int count() const { return childCount(); }

    void   saveState    (TDEConfig *) const;
    void   restoreState (TDEConfig *);


protected:

    TQDragObject *dragObject();
    void         dragEnterEvent(TQDragEnterEvent* event);
    void         dropEvent(TQDropEvent* event);
    void         contentsDragEnterEvent(TQDragEnterEvent* event);
    void         contentsDragMoveEvent(TQDragMoveEvent* event);
    void         contentsDropEvent(TQDropEvent* event);

protected slots:

    void slotStationActivation(TQListViewItem *);
    void slotCurrentStationChanged(TQListViewItem *);

signals:
    void sigStationActivated(int idx);
    void sigCurrentStationChanged(int idx);
    void sigStationsReceived(const TQStringList &stationIDs);

protected:

    TQStringList  m_StationIDs;

};

#endif
