/*
    cwbuglistcontainer.h  -  Container for the bug list

    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KBBMAINWINDOW_CWBUGLISTCONTAINER_H
#define KBBMAINWINDOW_CWBUGLISTCONTAINER_H

#include "package.h"
#include "bug.h"

#include <tqwidget.h>

class TDEListView;
class KFind;
class BugCommand;
class BugLVI;

namespace KBugBusterMainWindow
{

class CWLoadingWidget;

/**
 * @author Martijn Klingens
 */
class CWBugListContainer : public TQWidget
{
    TQ_OBJECT
  

public:
    CWBugListContainer( TQWidget* parent = 0, const char* name = 0 );
    ~CWBugListContainer();

    void setBugList( const Package &package, const TQString &component, const Bug::List &bugs );

    /**
     * Overloaded method that takes a TQString for the label. To be used when the
     * bug list doesn't belong to a package, liek search results
     */
    void setBugList( const TQString &label, const Bug::List &bugs );

    void searchBugByTitle( int options, const TQString& pattern );

    /** Return list of selected bugs in the listview. Used for merging. */
    TQStringList selectedBugs() const;

public slots:
    void setNoList();
    void setLoading( const Package &package, const TQString &component );
    void setLoading( const TQString &label );
    void setCacheMiss( const Package &package );
    void setCacheMiss( const TQString &label );
    void slotFindNext();

signals:
    void resetProgressBar();
    void searchPackage();

    void executed( const Bug & );
    void currentChanged( const Bug & );

private slots:
    void execute( TQListViewItem * );
    void changeCurrent( TQListViewItem * );

    void markBugCommand( BugCommand * );
    void clearCommand( const TQString & );

    void searchHighlight( const TQString &, int, int );

private:
    TQLabel *m_listLabel;
    TQWidgetStack *m_listStack;

    TDEListView *m_listBugs;
    KFind *m_find;
    BugLVI *m_findItem;

    CWLoadingWidget *m_listLoading;
};

}   // namespace

#endif
