/***************************************************************************
                          koptionsdlg.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by François Dupoux
                           (C) 2004 Emiliano Gulmini <emi_barbarossa@yahoo.it>
    email                : dupoux@dupoux.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqwhatsthis.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqlineedit.h>

// KDE
#include <kcharsets.h>
#include <kcombobox.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdestandarddirs.h>
#include <tdeapplication.h>
//#include <kdebug.h>

// local
#include "whatthis.h"
#include "koptionsdlg.h"


using namespace whatthisNameSpace;


KOptionsDlg::KOptionsDlg(RCOptions* info, TQWidget *parent, const char *name) : KOptionsDlgS(parent,name,true)
{
  m_config = new TDEConfig("tdefilereplacerc");
  m_option = info;

  initGUI();

  connect(m_pbOK, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotOK()));
  connect(m_pbDefault, TQ_SIGNAL(clicked()),this,TQ_SLOT(slotDefaults()));
  connect(m_chbBackup, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotChbBackup(bool)));
  connect(m_pbHelp, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotHelp()));
  connect(m_chbConfirmStrings, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotChbConfirmStrings(bool)));
  connect(m_chbShowConfirmDialog, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotChbShowConfirmDialog(bool)));

  whatsThis();
}

KOptionsDlg::~KOptionsDlg()
{
}

//PRIVATE SLOTS
void KOptionsDlg::slotOK()
{
  saveRCOptions();
  accept();
}

/** Set defaults values for all options of the dialog */
void KOptionsDlg::slotDefaults()
{
  m_chbCaseSensitive->setChecked(CaseSensitiveOption);
  m_chbRecursive->setChecked(RecursiveOption);
  m_chbHaltOnFirstOccurrence->setChecked(StopWhenFirstOccurenceOption);

  m_chbFollowSymLinks->setChecked(FollowSymbolicLinksOption);
  m_chbIgnoreHidden->setChecked(IgnoreHiddenOption);
  m_chbRegularExpressions->setChecked(RegularExpressionsOption);
  m_chbIgnoreFiles->setChecked(IgnoreFilesOption);
  m_chbConfirmStrings->setChecked(AskConfirmReplaceOption);

  TQStringList bkList = TQStringList::split(",",BackupExtensionOption,true);

  bool enableBackup = (bkList[0] == "true" ? true : false);

  m_chbBackup->setChecked(enableBackup);
  m_leBackup->setEnabled(enableBackup);
  m_tlBackup->setEnabled(enableBackup);

  m_leBackup->setText(bkList[1]);

  m_chbVariables->setChecked(VariablesOption);

  m_chbNotifyOnErrors->setChecked(NotifyOnErrorsOption);
}

void KOptionsDlg::slotChbBackup(bool b)
{
  m_leBackup->setEnabled(b);
  m_tlBackup->setEnabled(b);
}

void KOptionsDlg::slotChbConfirmStrings(bool b)
{
  if(b)
  {
    m_chbShowConfirmDialog->setEnabled(true);
    m_chbShowConfirmDialog->setChecked(true);
    m_config->setGroup("Notification Messages");
    m_config->writeEntry(rcDontAskAgain,"no");
  }
  else
  {
    m_chbShowConfirmDialog->setEnabled(false);
    m_chbShowConfirmDialog->setChecked(false);
    m_config->setGroup("Notification Messages");
    m_config->writeEntry(rcDontAskAgain,"yes");
  }
}

void KOptionsDlg::slotChbShowConfirmDialog(bool b)
{
  m_config->setGroup("Notification Messages");
  if(b)
  {
    m_config->writeEntry(rcDontAskAgain,"no");
  }
  else
  {
    m_config->writeEntry(rcDontAskAgain,"yes");
  }
}

//PRIVATE
void KOptionsDlg::initGUI()
{
  m_config->sync();
  m_config->setGroup("Notification Messages");
  m_option->m_notifyOnErrors = m_config->readBoolEntry(rcNotifyOnErrors, true);

  TQString dontAskAgain = m_config->readEntry(rcDontAskAgain,"no");

  m_chbConfirmStrings->setChecked(m_option->m_askConfirmReplace);

  if(m_chbConfirmStrings->isChecked())
  {
    if(dontAskAgain == "yes")
      m_chbShowConfirmDialog->setChecked(false);
    else
      m_chbShowConfirmDialog->setChecked(true);
  }
  
  TQStringList availableEncodingNames(TDEGlobal::charsets()->availableEncodingNames());
  m_cbEncoding->insertStringList( availableEncodingNames );
  int idx = -1;
  int utf8Idx = -1;
  for (uint i = 0; i < availableEncodingNames.count(); i++)
  {
    if (availableEncodingNames[i] == m_option->m_encoding)
    {
      idx = i;
      break;
    }
    if (availableEncodingNames[i] == "utf8")
    {
      utf8Idx = i;
    }
  }
  if (idx != -1)
    m_cbEncoding->setCurrentItem(idx);
  else 
    m_cbEncoding->setCurrentItem(utf8Idx);

  m_chbCaseSensitive->setChecked(m_option->m_caseSensitive);
  m_chbRecursive->setChecked(m_option->m_recursive);

  bool enableBackup = m_option->m_backup;

  m_chbBackup->setChecked(enableBackup);
  m_leBackup->setEnabled(enableBackup);
  m_tlBackup->setEnabled(enableBackup);

  m_leBackup->setText(m_option->m_backupExtension);

  m_chbVariables->setChecked(m_option->m_variables);
  m_chbRegularExpressions->setChecked(m_option->m_regularExpressions);
  m_chbHaltOnFirstOccurrence->setChecked(m_option->m_haltOnFirstOccur);
  m_chbFollowSymLinks->setChecked(m_option->m_followSymLinks);
  m_chbIgnoreHidden->setChecked(m_option->m_ignoreHidden);
  m_chbIgnoreFiles->setChecked(m_option->m_ignoreFiles);

  m_chbNotifyOnErrors->setChecked(m_option->m_notifyOnErrors);
}

void KOptionsDlg::saveRCOptions()
{
  m_option->m_encoding = m_cbEncoding->currentText();
  m_option->m_caseSensitive = m_chbCaseSensitive->isChecked();
  m_option->m_recursive = m_chbRecursive->isChecked();
  TQString backupExt = m_leBackup->text();
  m_option->m_backup = (m_chbBackup->isChecked() && !backupExt.isEmpty());
  m_option->m_backupExtension = backupExt;
  m_option->m_variables = m_chbVariables->isChecked();
  m_option->m_regularExpressions = m_chbRegularExpressions->isChecked();
  m_option->m_haltOnFirstOccur = m_chbHaltOnFirstOccurrence->isChecked();
  m_option->m_followSymLinks = m_chbFollowSymLinks->isChecked();
  m_option->m_ignoreHidden = m_chbIgnoreHidden->isChecked();
  m_option->m_ignoreFiles = m_chbIgnoreFiles->isChecked();
  m_option->m_askConfirmReplace = m_chbConfirmStrings->isChecked();
  m_option->m_notifyOnErrors = m_chbNotifyOnErrors->isChecked();

  m_config->setGroup("Notification Messages");
  m_config->writeEntry(rcNotifyOnErrors, m_option->m_notifyOnErrors);

  m_config->sync();
}

void KOptionsDlg::whatsThis()
{
  // Create help TQWhatsThis
  TQWhatsThis::add(m_chbCaseSensitive, chbCaseSensitiveWhatthis);
  TQWhatsThis::add(m_chbRecursive, chbRecursiveWhatthis);
  TQWhatsThis::add(m_chbHaltOnFirstOccurrence, chbHaltOnFirstOccurrenceWhatthis);
  TQWhatsThis::add(m_chbFollowSymLinks, chbFollowSymLinksWhatthis);
  TQWhatsThis::add(m_chbIgnoreHidden, chbIgnoreHiddenWhatthis);
  TQWhatsThis::add(m_chbIgnoreFiles, chbIgnoreFilesWhatthis);
  TQWhatsThis::add(m_chbRegularExpressions, chbRegularExpressionsWhatthis);
  TQWhatsThis::add(m_chbVariables, chbVariablesWhatthis);
  TQWhatsThis::add(m_chbBackup, chbBackupWhatthis);
  TQWhatsThis::add(m_chbConfirmStrings, chbConfirmStringsWhatthis);
}

#include "koptionsdlg.moc"
