/***************************************************************************
                          quantaplugin.h  -  description
                             -------------------
    begin                : Mon Sep 16 2002
    copyright            : (C) 2002 by Marc Britton <consume@optushome.com.au>
                           (C) 2003-2004 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTAPLUGIN_H
#define QUANTAPLUGIN_H

/* KDE INCLUDES */
#include <tdeparts/part.h>

/* QT INCLUDES */
#include <tqguardedptr.h>
#include <tqobject.h>

class TQString;

/**Base class for quanta plugins
  *@author Marc Britton
  */

class TDEToggleAction;
class KMdiToolViewAccessor;

class QuantaView;

class QuantaPlugin : public TQObject
{
  TQ_OBJECT
  
public:
  QuantaPlugin();
  ~QuantaPlugin();
  virtual bool isRunning() const;
  /** Gets the superficial plugin name */
  virtual TQString pluginName() const;
  /** Gets the location of the plugin */
  virtual TQString location() const;
  /** Gets the plugin's standard attribute */
  virtual bool isStandard() const;
  /** Gets the output window */
  virtual TQString outputWindow() const;
  /** Returns true if the plugin specified by a_plugin is valid, false otherwise */
  static bool validatePlugin(QuantaPlugin *);
  /** Returns true if the options of a plugin are valid, otherwise false */
  static bool validatePluginInfo(const TQString &, const TQString &,
              const TQString &, const TQString &);

  virtual void addWidget();
  virtual void removeWidget();
  TQWidget *widget();
  KParts::ReadOnlyPart *part() {return m_part;}
  TQString name() {return m_name;}
  /** plugs action into menu */
  void plugAction(TQPopupMenu *menu);
public slots:
  /** Sets whether the plugin is running or not */
  virtual void setRunning(bool);
  /** Loads the plugin */
  virtual bool load();
  /** Unloads te plugin. If remove is true, it will also remove the plugin widget. */
  virtual bool unload(bool remove = true);
  /** Runs the plugin */
  virtual bool run();
  /** Runs the plugin if it's not running yet, unloads otherwise.*/
  virtual bool toggle();
  /** Sets the superficial name of the plugin */
  virtual void setPluginName(const TQString &);
  /** Sets the output window */
  virtual void setOutputWindow(const TQString &);
  /** Sets the plugin's standard attribute */
  virtual void setStandard(bool isStandard);
  /** Sets the location of the plugin */
  virtual void setLocation(const TQString &);
  /** Sets the file name of the plugin */
  virtual void setFileName(const TQString &);
  /** Returns the file name of the plugin */
  virtual TQString fileName() const;
  virtual int input() {return m_input;}
  virtual void setInput(int a_input) { m_input = a_input;}
  /** Returns whether the plugin is loaded or not */
  virtual bool isLoaded();
  /** No descriptions */
  void setIcon(const TQString& a_icon);
  /** No descriptions */
  TQString icon();
  /** No descriptions */
  void setStandardName(const TQString& a_stdName);
  /** No descriptions */
  TQString standardName();
  void setReadOnlyPart(bool a_readOnlyPart) {m_readOnlyPart = a_readOnlyPart;}
  bool readOnlyPart() {return m_readOnlyPart;}
signals:
  void pluginStarted();
  void pluginStopped();
protected:
  /** Superficial name of plugin */
  TQString m_fileName;
  TQString m_name;
  TQString m_location;
  TQString m_icon;
  TQString m_outputWindow;
  int m_input;
  /** True, if it is not a user added plugin. Special handling code may be necessary for standard plugins. */
  bool m_standard;
  bool m_isRunning;
  TQGuardedPtr<KParts::ReadOnlyPart> m_part;
  bool m_readOnlyPart;
  QuantaView *m_view;
  TDEToggleAction *m_action;
private: // Private attributes
  TQString m_standardName;
  KMdiToolViewAccessor* m_pluginToolView;
  TQWidget *m_targetWidget; //this will be the parent, used only to make the plugin widget hidden until addWidget is called
};

#endif
