/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef XSLTEXPORTER_H
#define XSLTEXPORTER_H

class KURLRequester;

#include "exporter.h"

namespace Tellico {
  namespace Export {

/**
 * @author Robby Stephenson
 */
class XSLTExporter : public Exporter {
public:
  XSLTExporter();

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget* parent, const char* name=0);

  virtual void readOptions(TDEConfig* cfg);
  virtual void saveOptions(TDEConfig* cfg);

private:
  TQWidget* m_widget;
  KURLRequester* m_URLRequester;
  TQString m_xsltFile;
};

  } // end namespace
} // end namespace
#endif
