//
// C++ Implementation: pixmaps
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "pixmaps.h"
#include "malloryhandler.h"

#include <kdecoration.h>
#include <tqpainter.h>
#include <kpixmapeffect.h>
#include <kpixmap.h>
#include <kpixmapio.h>
#include <tqimage.h>
#include <tqpixmap.h>

// Static declarations for linking.
TQPixmap *Pixmaps::active_button_ground = 0;
TQPixmap *Pixmaps::inactive_button_ground = 0;

TQImage *Pixmaps::active_help_normal = 0;
TQImage *Pixmaps::active_max_normal = 0;
TQImage *Pixmaps::active_restore_normal = 0;
TQImage *Pixmaps::active_min_normal = 0;
TQImage *Pixmaps::active_close_normal = 0;
TQImage *Pixmaps::active_sticky_normal = 0;
TQImage *Pixmaps::active_unsticky_normal = 0;
TQImage *Pixmaps::active_above_normal = 0;
TQImage *Pixmaps::active_below_normal = 0;

TQImage *Pixmaps::active_help_hover = 0;
TQImage *Pixmaps::active_max_hover = 0;
TQImage *Pixmaps::active_restore_hover = 0;
TQImage *Pixmaps::active_min_hover = 0;
TQImage *Pixmaps::active_close_hover = 0;
TQImage *Pixmaps::active_sticky_hover = 0;
TQImage *Pixmaps::active_unsticky_hover = 0;
TQImage *Pixmaps::active_above_hover = 0;
TQImage *Pixmaps::active_below_hover = 0;

TQImage *Pixmaps::active_help_sunken = 0;
TQImage *Pixmaps::active_max_sunken = 0;
TQImage *Pixmaps::active_restore_sunken = 0;
TQImage *Pixmaps::active_min_sunken = 0;
TQImage *Pixmaps::active_close_sunken = 0;
TQImage *Pixmaps::active_sticky_sunken = 0;
TQImage *Pixmaps::active_unsticky_sunken = 0;
TQImage *Pixmaps::active_above_sunken = 0;
TQImage *Pixmaps::active_below_sunken = 0;

TQImage *Pixmaps::inactive_help_normal = 0;
TQImage *Pixmaps::inactive_max_normal = 0;
TQImage *Pixmaps::inactive_restore_normal = 0;
TQImage *Pixmaps::inactive_min_normal = 0;
TQImage *Pixmaps::inactive_close_normal = 0;
TQImage *Pixmaps::inactive_sticky_normal = 0;
TQImage *Pixmaps::inactive_unsticky_normal = 0;
TQImage *Pixmaps::inactive_above_normal = 0;
TQImage *Pixmaps::inactive_below_normal = 0;

TQImage *Pixmaps::inactive_help_hover = 0;
TQImage *Pixmaps::inactive_max_hover = 0;
TQImage *Pixmaps::inactive_restore_hover = 0;
TQImage *Pixmaps::inactive_min_hover = 0;
TQImage *Pixmaps::inactive_close_hover = 0;
TQImage *Pixmaps::inactive_sticky_hover = 0;
TQImage *Pixmaps::inactive_unsticky_hover = 0;
TQImage *Pixmaps::inactive_above_hover = 0;
TQImage *Pixmaps::inactive_below_hover = 0;

TQImage *Pixmaps::inactive_help_sunken = 0;
TQImage *Pixmaps::inactive_max_sunken = 0;
TQImage *Pixmaps::inactive_restore_sunken = 0;
TQImage *Pixmaps::inactive_min_sunken = 0;
TQImage *Pixmaps::inactive_close_sunken = 0;
TQImage *Pixmaps::inactive_sticky_sunken = 0;
TQImage *Pixmaps::inactive_unsticky_sunken = 0;
TQImage *Pixmaps::inactive_above_sunken = 0;
TQImage *Pixmaps::inactive_below_sunken = 0;

TQPixmap *Pixmaps::active_titlebar = 0;
TQPixmap *Pixmaps::active_titlebar_left = 0;
TQPixmap *Pixmaps::active_titlebar_right = 0;
TQPixmap *Pixmaps::inactive_titlebar = 0;
TQPixmap *Pixmaps::inactive_titlebar_left = 0;
TQPixmap *Pixmaps::inactive_titlebar_right = 0;

bool Pixmaps::pixmapsCreated = false;

//
static int round_help[] = {
0xF,0xF,0xF,0x8,0x4,0x0,0x0,0x4,0x8,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x0,0x8,0x8,0x0,0x0,0x4,0xF,0xF,
0xF,0x8,0x0,0x4,0xF,0xF,0xF,0xF,0x4,0x0,0x8,0xF,
0xF,0x0,0x0,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x0,0x8,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0x8,0x0,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x4,0x8,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0x8,0x0,0x0,0x8,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0xF
};
//
static int round_max[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x6,0xC,0x8,0x4,0x0,0x4,0xF,0xF,
0xF,0x4,0x3,0xC,0xC,0x6,0x4,0xE,0xE,0x4,0x4,0xF,
0xC,0x0,0xC,0xC,0xC,0x0,0xC,0xF,0xF,0xE,0x0,0xC,
0x4,0x6,0xC,0xC,0xC,0x0,0xC,0xF,0xF,0xE,0x4,0x4,
0x0,0xC,0xC,0xC,0xC,0x6,0x4,0xC,0xC,0x4,0x8,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0x6,0x0,0x0,0x6,0xC,0x0,
0x4,0x6,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x6,0x4,
0xC,0x0,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0,0xC,
0xF,0x4,0x3,0xC,0xC,0xC,0xC,0xC,0xC,0x3,0x4,0xF,
0xF,0xF,0x4,0x0,0x6,0xC,0xC,0x6,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_restore[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xC,0x0,0xF,0xF,0x8,0x0,0x0,0x8,0xF,0xF,0x0,0xC,
0x4,0x8,0xF,0x8,0x4,0xC,0xC,0x4,0x8,0xF,0x8,0x4,
0x0,0xF,0xF,0x0,0xC,0xF,0xF,0xC,0x0,0xF,0xF,0x0,
0x0,0xF,0xF,0x0,0xC,0xF,0xF,0xC,0x0,0xF,0xF,0x0,
0x4,0x8,0xF,0x8,0x4,0xC,0xC,0x4,0x8,0xF,0x8,0x4,
0xC,0x0,0xF,0xF,0x8,0x0,0x0,0x8,0xF,0xF,0x0,0xC,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_min[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x4,0x8,0xF,0xF,0x8,0x4,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xC,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0xC,
0x4,0x8,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x8,0x4,
0x0,0xF,0x8,0x0,0x0,0x8,0xF,0xF,0xF,0xF,0xF,0x0,
0x2,0x8,0x3,0x9,0x9,0x3,0x8,0xF,0xF,0xF,0xF,0x0,
0xA,0x0,0x9,0xC,0xC,0x9,0x0,0xF,0xF,0xF,0x8,0x4,
0xE,0x0,0x9,0xC,0xC,0x9,0x0,0xF,0xF,0xF,0x4,0xC,
0xF,0x6,0x3,0x9,0x9,0x3,0x8,0xF,0xF,0x4,0x4,0xF,
0xF,0xF,0x6,0x0,0x0,0x8,0xF,0x8,0x4,0x4,0xF,0xF,
0xF,0xF,0xF,0xE,0xA,0x2,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_close[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x6,0xC,0xC,0x6,0x0,0x4,0xF,0xF,
0xF,0x4,0x3,0xC,0xC,0xC,0xC,0xC,0xC,0x3,0x4,0xF,
0xC,0x0,0xC,0x3,0x9,0xC,0xC,0x9,0x3,0xC,0x0,0xC,
0x4,0x6,0xC,0x9,0x0,0x9,0x9,0x0,0x9,0xC,0x6,0x4,
0x0,0xC,0xC,0xC,0x9,0x0,0x0,0x9,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0x9,0x0,0x0,0x9,0xC,0xC,0xC,0x0,
0x4,0x6,0xC,0x9,0x0,0x9,0x9,0x0,0x9,0xC,0x6,0x4,
0xC,0x0,0xC,0x3,0x9,0xC,0xC,0x9,0x3,0xC,0x0,0xC,
0xF,0x4,0x3,0xC,0xC,0xC,0xC,0xC,0xC,0x3,0x4,0xF,
0xF,0xF,0x4,0x0,0x6,0xC,0xC,0x6,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_sticky[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xC,0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0xC,
0x4,0x8,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x8,0x4,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x4,0x8,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x8,0x4,
0xC,0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0xC,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_unsticky[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xC,0x0,0x0,0xC,0xF,0x4,0x4,0xF,
0xC,0x0,0xF,0xF,0x8,0x6,0x6,0x8,0xF,0xF,0x0,0xC,
0x4,0x8,0xC,0x8,0x4,0x6,0x6,0x4,0x8,0xC,0x8,0x4,
0x0,0xF,0x0,0x6,0x6,0x9,0x9,0x6,0x6,0x0,0xF,0x0,
0x0,0xF,0x0,0x6,0x6,0x9,0x9,0x6,0x6,0x0,0xF,0x0,
0x4,0x8,0xC,0x8,0x4,0x6,0x6,0x4,0x8,0xC,0x8,0x4,
0xC,0x0,0xF,0xF,0x8,0x6,0x6,0x8,0xF,0xF,0x0,0xC,
0xF,0x4,0x4,0xF,0xC,0x0,0x0,0xC,0xF,0x4,0x4,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_above[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xF,0xC,0xC,0xF,0xF,0x4,0x4,0xF,
0xC,0x0,0xF,0xF,0xF,0x4,0x4,0xF,0xF,0xF,0x0,0xC,
0x4,0x8,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0x8,0x4,
0x0,0xF,0xF,0xF,0x4,0x0,0x0,0x4,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0xC,0xF,0xF,0x0,
0x4,0x8,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0x8,0x4,
0xC,0x0,0xF,0x8,0x8,0x8,0x8,0x8,0x8,0xF,0x0,0xC,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};
//
static int round_below[] = {
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x4,0x4,0xF,
0xC,0x0,0xF,0x8,0x8,0x8,0x8,0x8,0x8,0xF,0x0,0xC,
0x4,0x8,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0x8,0x4,
0x0,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0xC,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0x4,0x0,0x0,0x4,0xF,0xF,0xF,0x0,
0x4,0x8,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0x8,0x4,
0xC,0x0,0xF,0xF,0xF,0x4,0x4,0xF,0xF,0xF,0x0,0xC,
0xF,0x4,0x4,0xF,0xF,0xC,0xC,0xF,0xF,0x4,0x4,0xF,
0xF,0xF,0x4,0x0,0x8,0xF,0xF,0x8,0x0,0x4,0xF,0xF,
0xF,0xF,0xF,0xC,0x4,0x0,0x0,0x4,0xC,0xF,0xF,0xF
};

//
static int square_help[] = {
0xF,0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,0xF,
0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF,
0xF,0x0,0x0,0xC,0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xF,
0xF,0x4,0x4,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0x0,0x0,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0x0,0xC,0xF,
0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0x8,0x0,0x0,0x8,0xF,0xF,0xF,0xF,
0xF,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0xF
};
//
static int square_max[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,
0x0,0x9,0xC,0xC,0xC,0xC,0x8,0xF,0xF,0xF,0xC,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0x3,0x0,0x0,0x0,0x8,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x0,
0x0,0x9,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x9,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_restore[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0xF,0x0,
0x0,0xF,0xF,0x0,0xF,0xF,0xF,0xF,0x0,0xF,0xF,0x0,
0x0,0xF,0xF,0x0,0xF,0xF,0xF,0xF,0x0,0xF,0xF,0x0,
0x0,0xF,0xF,0x0,0xF,0xF,0xF,0xF,0x0,0xF,0xF,0x0,
0x0,0xF,0xF,0x0,0xF,0xF,0xF,0xF,0x0,0xF,0xF,0x0,
0x0,0xF,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_min[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x8,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x2,0x0,0x0,0x0,0x0,0x4,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xB,0xC,0xC,0xC,0x0,0xF,0xF,0xF,0xF,0xC,0x0,
0x4,0x0,0x0,0x0,0x0,0x2,0x8,0x0,0x0,0x0,0x0,0xC
};
//
static int square_close[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0x9,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x9,0x0,
0x0,0xC,0xC,0x6,0xC,0xC,0xC,0xC,0x6,0xC,0xC,0x0,
0x0,0xC,0x6,0x0,0x3,0xC,0xC,0x3,0x0,0x6,0xC,0x0,
0x0,0xC,0xC,0x3,0x0,0x3,0x3,0x0,0x3,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0x3,0x0,0x0,0x3,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0xC,0x3,0x0,0x0,0x3,0xC,0xC,0xC,0x0,
0x0,0xC,0xC,0x3,0x0,0x3,0x3,0x0,0x3,0xC,0xC,0x0,
0x0,0xC,0x6,0x0,0x3,0xC,0xC,0x3,0x0,0x6,0xC,0x0,
0x0,0xC,0xC,0x6,0xC,0xC,0xC,0xC,0x6,0xC,0xC,0x0,
0x0,0x9,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0xC,0x9,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_sticky[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_unsticky[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0x8,0x6,0x6,0x8,0xF,0xF,0xF,0x0,
0x0,0xF,0xC,0x8,0x4,0x6,0x6,0x4,0x8,0xC,0xF,0x0,
0x0,0xF,0x0,0x6,0x6,0x9,0x9,0x6,0x6,0x0,0xF,0x0,
0x0,0xF,0x0,0x6,0x6,0x9,0x9,0x6,0x6,0x0,0xF,0x0,
0x0,0xF,0xC,0x8,0x4,0x6,0x6,0x4,0x8,0xC,0xF,0x0,
0x0,0xF,0xF,0xF,0x8,0x6,0x6,0x8,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0x0,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_above[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xF,0xC,0xC,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0x4,0x4,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0x4,0x0,0x0,0x4,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0xC,0xF,0xF,0x0,
0x0,0xF,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0xF,0x0,
0x0,0xF,0xF,0x8,0x8,0x8,0x8,0x8,0x8,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};
//
static int square_below[] = {
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0x8,0x8,0x8,0x8,0x8,0x8,0xF,0xF,0x0,
0x0,0xF,0xF,0x4,0x0,0x0,0x0,0x0,0x4,0xF,0xF,0x0,
0x0,0xF,0xF,0xC,0x0,0x0,0x0,0x0,0xC,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0x4,0x0,0x0,0x4,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xC,0x0,0x0,0xC,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0x4,0x4,0xF,0xF,0xF,0xF,0x0,
0x0,0xF,0xF,0xF,0xF,0xC,0xC,0xF,0xF,0xF,0xF,0x0,
0x0,0xC,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xC,0x0,
0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC
};

void Pixmaps::createPixmaps()
{
	if (pixmapsCreated)
		return;

	static int *alias_help;
	static int *alias_max;
	static int *alias_restore;
	static int *alias_min;
	static int *alias_close;
	static int *alias_sticky;
	static int *alias_unsticky;
	static int *alias_above;
	static int *alias_below;

	if (MalloryHandler::buttonStyle() == 1)
	{
		alias_help = square_help;
		alias_max = square_max;
		alias_restore = square_restore;
		alias_min = square_min;
		alias_close = square_close;
		alias_sticky = square_sticky;
		alias_unsticky = square_unsticky;
		alias_above = square_above;
		alias_below = square_below;
	}
	else
	{
		alias_help = round_help;
		alias_max = round_max;
		alias_restore = round_restore;
		alias_min = round_min;
		alias_close = round_close;
		alias_sticky = round_sticky;
		alias_unsticky = round_unsticky;
		alias_above = round_above;
		alias_below = round_below;
	}

	TQColor aColor = KDecoration::options()->color(KDecoration::ColorTitleBar, true);
	TQColor aColorBlend = KDecoration::options()->color(KDecoration::ColorTitleBlend, true);
	TQColor iColor = KDecoration::options()->color(KDecoration::ColorTitleBar, false);
	TQColor iColorBlend = KDecoration::options()->color(KDecoration::ColorTitleBlend, false);

	TQColor aBrite = KDecoration::options()->color(KDecoration::ColorFont, true);
	TQColor aShade = KDecoration::options()->color(KDecoration::ColorButtonBg, true);
	TQColor iBrite = KDecoration::options()->color(KDecoration::ColorFont, false);
	TQColor iShade = KDecoration::options()->color(KDecoration::ColorButtonBg, false);

	TQColor aHandle = KDecoration::options()->color(KDecoration::ColorHandle, true);
	TQColor iHandle = KDecoration::options()->color(KDecoration::ColorHandle, false);

	TQColor aFrame = KDecoration::options()->color(KDecoration::ColorFrame, true);
	TQColor iFrame = KDecoration::options()->color(KDecoration::ColorFrame, false);

	int buttonSize = MalloryHandler::buttonSize();
	int titleSize = MalloryHandler::titleSize();
	int titleShadow = MalloryHandler::titleShadowSize();

	if (!MalloryHandler::titleShadow()) // If shadow is disabled,
		titleShadow = 0;	    // do something special!

	TQPainter painter;
	KPixmap tempPixmap;

	// Let's begin with the title bar.
	active_titlebar = new TQPixmap(1, titleSize);
	painter.begin(active_titlebar);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, aColor, aColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	inactive_titlebar = new TQPixmap(1, titleSize);
	painter.begin(inactive_titlebar);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, iColor, iColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	active_titlebar_left = new TQPixmap(1, titleSize);
	painter.begin(active_titlebar_left);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, aColor, aColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	inactive_titlebar_left = new TQPixmap(1, titleSize);
	painter.begin(inactive_titlebar_left);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, iColor, iColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	active_titlebar_right = new TQPixmap(1, titleSize);
	painter.begin(active_titlebar_right);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, aColor, aColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	inactive_titlebar_right = new TQPixmap(1, titleSize);
	painter.begin(inactive_titlebar_right);
	tempPixmap.resize(1, titleSize);
	KPixmapEffect::gradient(tempPixmap, iColor, iColorBlend, KPixmapEffect::VerticalGradient);
	painter.drawPixmap(0, 0, tempPixmap);
	painter.end();

	// Let's create the button background.
	active_button_ground = new TQPixmap(buttonSize, buttonSize);
	painter.begin(active_button_ground);
	drawGround(&painter, true);
	painter.end();
	inactive_button_ground = new TQPixmap(buttonSize, buttonSize);
	painter.begin(inactive_button_ground);
	drawGround(&painter, false);
	painter.end();

	// Now, let's create the button icons!
	int off = (buttonSize-16)/2;
	TQPainter ikon;
	TQImage *aGround = new TQImage();
	TQImage *iGround = new TQImage();
	TQPixmap *tempGround = new TQPixmap(16, 16);
	ikon.begin(tempGround);
	ikon.drawPixmap(0, 0, *active_button_ground, off, off, 16, 16);
	*aGround = tempGround->convertToImage();
	*aGround = aGround->convertDepth(32);
	ikon.drawPixmap(0, 0, *inactive_button_ground, off, off, 16, 16);
	*iGround = tempGround->convertToImage();
	*iGround = iGround->convertDepth(32);
	ikon.end();
	int abr, abg, abb, asr, asg, asb;
	int ibr, ibg, ibb, isr, isg, isb;
	aBrite.getRgb(&abr, &abg, &abb);
	aShade.getRgb(&asr, &asg, &asb);
	iBrite.getRgb(&ibr, &ibg, &ibb);
	iShade.getRgb(&isr, &isg, &isb);
	// Lotsa work to do.
	// Zero...
	active_help_normal = new TQImage(16, 16, 32);
	bitBlt(active_help_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_help, *active_help_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_help, *active_help_normal, abr, abg, abb, 1);
	active_help_hover = new TQImage(16, 16, 32);
	bitBlt(active_help_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_help, *active_help_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_help, *active_help_hover, abr, abg, abb, 0);
	active_help_sunken = new TQImage(16, 16, 32);
	bitBlt(active_help_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_help, *active_help_sunken, abr, abg, abb, 2);
	inactive_help_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_help_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_help, *inactive_help_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_help, *inactive_help_normal, ibr, ibg, ibb, 1);
	inactive_help_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_help_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_help, *inactive_help_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_help, *inactive_help_hover, ibr, ibg, ibb, 0);
	inactive_help_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_help_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_help, *inactive_help_sunken, ibr, ibg, ibb, 2);
	// Six...
	active_max_normal = new TQImage(16, 16, 32);
	bitBlt(active_max_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_max, *active_max_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_max, *active_max_normal, abr, abg, abb, 1);
	active_max_hover = new TQImage(16, 16, 32);
	bitBlt(active_max_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_max, *active_max_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_max, *active_max_hover, abr, abg, abb, 0);
	active_max_sunken = new TQImage(16, 16, 32);
	bitBlt(active_max_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_max, *active_max_sunken, abr, abg, abb, 2);
	inactive_max_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_max_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_max, *inactive_max_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_max, *inactive_max_normal, ibr, ibg, ibb, 1);
	inactive_max_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_max_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_max, *inactive_max_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_max, *inactive_max_hover, ibr, ibg, ibb, 0);
	inactive_max_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_max_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_max, *inactive_max_sunken, ibr, ibg, ibb, 2);
	// Twelve...
	active_restore_normal = new TQImage(16, 16, 32);
	bitBlt(active_restore_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_restore, *active_restore_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_restore, *active_restore_normal, abr, abg, abb, 1);
	active_restore_hover = new TQImage(16, 16, 32);
	bitBlt(active_restore_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_restore, *active_restore_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_restore, *active_restore_hover, abr, abg, abb, 0);
	active_restore_sunken = new TQImage(16, 16, 32);
	bitBlt(active_restore_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_restore, *active_restore_sunken, abr, abg, abb, 2);
	inactive_restore_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_restore_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_restore, *inactive_restore_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_restore, *inactive_restore_normal, ibr, ibg, ibb, 1);
	inactive_restore_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_restore_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_restore, *inactive_restore_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_restore, *inactive_restore_hover, ibr, ibg, ibb, 0);
	inactive_restore_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_restore_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_restore, *inactive_restore_sunken, ibr, ibg, ibb, 2);
	// Eighteen
	active_min_normal = new TQImage(16, 16, 32);
	bitBlt(active_min_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_min, *active_min_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_min, *active_min_normal, abr, abg, abb, 1);
	active_min_hover = new TQImage(16, 16, 32);
	bitBlt(active_min_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_min, *active_min_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_min, *active_min_hover, abr, abg, abb, 0);
	active_min_sunken = new TQImage(16, 16, 32);
	bitBlt(active_min_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_min, *active_min_sunken, abr, abg, abb, 2);
	inactive_min_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_min_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_min, *inactive_min_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_min, *inactive_min_normal, ibr, ibg, ibb, 1);
	inactive_min_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_min_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_min, *inactive_min_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_min, *inactive_min_hover, ibr, ibg, ibb, 0);
	inactive_min_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_min_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_min, *inactive_min_sunken, ibr, ibg, ibb, 2);
	// Twenty four...
	active_close_normal = new TQImage(16, 16, 32);
	bitBlt(active_close_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_close, *active_close_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_close, *active_close_normal, abr, abg, abb, 1);
	active_close_hover = new TQImage(16, 16, 32);
	bitBlt(active_close_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_close, *active_close_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_close, *active_close_hover, abr, abg, abb, 0);
	active_close_sunken = new TQImage(16, 16, 32);
	bitBlt(active_close_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_close, *active_close_sunken, abr, abg, abb, 2);
	inactive_close_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_close_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_close, *inactive_close_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_close, *inactive_close_normal, ibr, ibg, ibb, 1);
	inactive_close_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_close_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_close, *inactive_close_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_close, *inactive_close_hover, ibr, ibg, ibb, 0);
	inactive_close_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_close_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_close, *inactive_close_sunken, ibr, ibg, ibb, 2);
	// Thirty...
	active_sticky_normal = new TQImage(16, 16, 32);
	bitBlt(active_sticky_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_sticky, *active_sticky_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_sticky, *active_sticky_normal, abr, abg, abb, 1);
	active_sticky_hover = new TQImage(16, 16, 32);
	bitBlt(active_sticky_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_sticky, *active_sticky_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_sticky, *active_sticky_hover, abr, abg, abb, 0);
	active_sticky_sunken = new TQImage(16, 16, 32);
	bitBlt(active_sticky_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_sticky, *active_sticky_sunken, abr, abg, abb, 2);
	inactive_sticky_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_sticky_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_sticky, *inactive_sticky_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_sticky, *inactive_sticky_normal, ibr, ibg, ibb, 1);
	inactive_sticky_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_sticky_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_sticky, *inactive_sticky_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_sticky, *inactive_sticky_hover, ibr, ibg, ibb, 0);
	inactive_sticky_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_sticky_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_sticky, *inactive_sticky_sunken, ibr, ibg, ibb, 2);
	// Thirty six...
	active_unsticky_normal = new TQImage(16, 16, 32);
	bitBlt(active_unsticky_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_unsticky, *active_unsticky_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_unsticky, *active_unsticky_normal, abr, abg, abb, 1);
	active_unsticky_hover = new TQImage(16, 16, 32);
	bitBlt(active_unsticky_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_unsticky, *active_unsticky_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_unsticky, *active_unsticky_hover, abr, abg, abb, 0);
	active_unsticky_sunken = new TQImage(16, 16, 32);
	bitBlt(active_unsticky_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_unsticky, *active_unsticky_sunken, abr, abg, abb, 2);
	inactive_unsticky_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_unsticky_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_unsticky, *inactive_unsticky_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_unsticky, *inactive_unsticky_normal, ibr, ibg, ibb, 1);
	inactive_unsticky_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_unsticky_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_unsticky, *inactive_unsticky_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_unsticky, *inactive_unsticky_hover, ibr, ibg, ibb, 0);
	inactive_unsticky_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_unsticky_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_unsticky, *inactive_unsticky_sunken, ibr, ibg, ibb, 2);
	// Forty two...
	active_above_normal = new TQImage(16, 16, 32);
	bitBlt(active_above_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_above, *active_above_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_above, *active_above_normal, abr, abg, abb, 1);
	active_above_hover = new TQImage(16, 16, 32);
	bitBlt(active_above_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_above, *active_above_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_above, *active_above_hover, abr, abg, abb, 0);
	active_above_sunken = new TQImage(16, 16, 32);
	bitBlt(active_above_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_above, *active_above_sunken, abr, abg, abb, 2);
	inactive_above_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_above_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_above, *inactive_above_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_above, *inactive_above_normal, ibr, ibg, ibb, 1);
	inactive_above_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_above_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_above, *inactive_above_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_above, *inactive_above_hover, ibr, ibg, ibb, 0);
	inactive_above_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_above_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_above, *inactive_above_sunken, ibr, ibg, ibb, 2);
	// Forty eight...
	active_below_normal = new TQImage(16, 16, 32);
	bitBlt(active_below_normal, 0, 0, aGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_below, *active_below_normal, asr, asg, asb, titleShadow+1);
	unicity(alias_below, *active_below_normal, abr, abg, abb, 1);
	active_below_hover = new TQImage(16, 16, 32);
	bitBlt(active_below_hover, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_below, *active_below_hover, asr, asg, asb, titleShadow+1);
	unicity(alias_below, *active_below_hover, abr, abg, abb, 0);
	active_below_sunken = new TQImage(16, 16, 32);
	bitBlt(active_below_sunken, 0, 0, aGround, 0, 0, 16, 16, 0);
	unicity(alias_below, *active_below_sunken, abr, abg, abb, 2);
	inactive_below_normal = new TQImage(16, 16, 32);
	bitBlt(inactive_below_normal, 0, 0, iGround, 0, 0, 16, 16, 0);
	if (titleShadow)
		unicity(alias_below, *inactive_below_normal, isr, isg, isb, titleShadow+1);
	unicity(alias_below, *inactive_below_normal, ibr, ibg, ibb, 1);
	inactive_below_hover = new TQImage(16, 16, 32);
	bitBlt(inactive_below_hover, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_below, *inactive_below_hover, isr, isg, isb, titleShadow+1);
	unicity(alias_below, *inactive_below_hover, ibr, ibg, ibb, 0);
	inactive_below_sunken = new TQImage(16, 16, 32);
	bitBlt(inactive_below_sunken, 0, 0, iGround, 0, 0, 16, 16, 0);
	unicity(alias_below, *inactive_below_sunken, ibr, ibg, ibb, 2);
	// Fifty four... Don't lose the count!
}

void Pixmaps::deletePixmaps()
{
	delete active_button_ground;
	active_button_ground = 0;
	delete inactive_button_ground;
	inactive_button_ground = 0;

	delete active_help_normal;
	active_help_normal = 0;
	delete active_max_normal;
	active_max_normal = 0;
	delete active_restore_normal;
	active_restore_normal = 0;
	delete active_min_normal;
	active_min_normal = 0;
	delete active_close_normal;
	active_close_normal = 0;
	delete active_sticky_normal;
	active_sticky_normal = 0;
	delete active_unsticky_normal;
	active_unsticky_normal = 0;
	delete active_above_normal;
	active_above_normal = 0;
	delete active_below_normal;
	active_below_normal = 0;

	delete active_help_hover;
	active_help_hover = 0;
	delete active_max_hover;
	active_max_hover = 0;
	delete active_restore_hover;
	active_restore_hover = 0;
	delete active_min_hover;
	active_min_hover = 0;
	delete active_close_hover;
	active_close_hover = 0;
	delete active_sticky_hover;
	active_sticky_hover = 0;
	delete active_unsticky_hover;
	active_unsticky_hover = 0;
	delete active_above_hover;
	active_above_hover = 0;
	delete active_below_hover;
	active_below_hover = 0;

	delete active_help_sunken;
	active_help_sunken = 0;
	delete active_max_sunken;
	active_max_sunken = 0;
	delete active_restore_sunken;
	active_restore_sunken = 0;
	delete active_min_sunken;
	active_min_sunken = 0;
	delete active_close_sunken;
	active_close_sunken = 0;
	delete active_sticky_sunken;
	active_sticky_sunken = 0;
	delete active_unsticky_sunken;
	active_unsticky_sunken = 0;
	delete active_above_sunken;
	active_above_sunken = 0;
	delete active_below_sunken;
	active_below_sunken = 0;

	delete inactive_help_normal;
	inactive_help_normal = 0;
	delete inactive_max_normal;
	inactive_max_normal = 0;
	delete inactive_restore_normal;
	inactive_restore_normal = 0;
	delete inactive_min_normal;
	inactive_min_normal = 0;
	delete inactive_close_normal;
	inactive_close_normal = 0;
	delete inactive_sticky_normal;
	inactive_sticky_normal = 0;
	delete inactive_unsticky_normal;
	inactive_unsticky_normal = 0;
	delete inactive_above_normal;
	inactive_above_normal = 0;
	delete inactive_below_normal;
	inactive_below_normal = 0;

	delete inactive_help_hover;
	inactive_help_hover = 0;
	delete inactive_max_hover;
	inactive_max_hover = 0;
	delete inactive_restore_hover;
	inactive_restore_hover = 0;
	delete inactive_min_hover;
	inactive_min_hover = 0;
	delete inactive_close_hover;
	inactive_close_hover = 0;
	delete inactive_sticky_hover;
	inactive_sticky_hover = 0;
	delete inactive_unsticky_hover;
	inactive_unsticky_hover = 0;
	delete inactive_above_hover;
	inactive_above_hover = 0;
	delete inactive_below_hover;
	inactive_below_hover = 0;

	delete inactive_help_sunken;
	inactive_help_sunken = 0;
	delete inactive_max_sunken;
	inactive_max_sunken = 0;
	delete inactive_restore_sunken;
	inactive_restore_sunken = 0;
	delete inactive_min_sunken;
	inactive_min_sunken = 0;
	delete inactive_close_sunken;
	inactive_close_sunken = 0;
	delete inactive_sticky_sunken;
	inactive_sticky_sunken = 0;
	delete inactive_unsticky_sunken;
	inactive_unsticky_sunken = 0;
	delete inactive_above_sunken;
	inactive_above_sunken = 0;
	delete inactive_below_sunken;
	inactive_below_sunken = 0;

	delete active_titlebar;
	active_titlebar = 0;
	delete active_titlebar_left;
	active_titlebar_left = 0;
	delete active_titlebar_right;
	active_titlebar_right = 0;

	delete inactive_titlebar;
	inactive_titlebar = 0;
	delete inactive_titlebar_left;
	inactive_titlebar_left = 0;
	delete inactive_titlebar_right;
	inactive_titlebar_right = 0;

	pixmapsCreated = false;
}

// Redo the buttons' background.
void Pixmaps::drawGround(TQPainter* painter, bool active)
{
	int buttonSize = MalloryHandler::buttonSize();
	int titleSize = MalloryHandler::titleSize();

	int buttonTop = (titleSize-buttonSize)/2;

	// Get the titlebar colors right behind the buttons for the gradient.
	TQImage *titlebar_image = new TQImage();
	*titlebar_image = active ? active_titlebar->convertToImage() : inactive_titlebar->convertToImage();
	TQColor title_color1 = titlebar_image->pixel(0, buttonTop);
	TQColor title_color2 = titlebar_image->pixel(0, buttonTop+buttonSize-1);

	// The temporary canvas.
	KPixmap tempPixmap;
	tempPixmap.resize(buttonSize, buttonSize);
	KPixmapEffect::gradient(tempPixmap, title_color1, title_color2, KPixmapEffect::VerticalGradient);
	painter->drawPixmap(0, 0, tempPixmap);

	delete titlebar_image;
}

void Pixmaps::unicity(int* alias, TQImage& work, int rr, int gg, int bb, int offset)
{
	int x, y;
	int z = 0;

	for (y=offset; y<offset+12; y++)
	{
		uint *line = (uint*)work.scanLine(y);
		for (x=offset; x<offset+12; x++)
		{
			switch (alias[z])
			{
				case 0xF:	// Keep background.
					break;
				case 0x0:	// Replace.
					line[x] = tqRgb(rr, gg, bb);
					break;
				default:	// 15-level colorization
					uint pxl = line[x];
					line[x] = tqRgb( (tqRed(pxl)*alias[z]+rr*(15-alias[z]))/15,
							(tqGreen(pxl)*alias[z]+gg*(15-alias[z]))/15,
							(tqBlue(pxl)*alias[z]+bb*(15-alias[z]))/15 );
			}
			z++;
		}
	}
}

