/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

// TQt
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqlayout.h>
#include <tqlabel.h>

// TDE
#include <tdelocale.h>
#include <kiconloader.h>
#include <twin.h>

// Portal
#include "permission_dialog.h"
#include "permission_dialog.moc"

TDEPermissionDialog::TDEPermissionDialog(TQString application, TQString feature,
                                         TQString icon, Dictionary details)

: KDialogBase(TQString::null, /* we set plain caption below */
              KDialogBase::Yes | KDialogBase::No | KDialogBase::Details,
              KDialogBase::NoDefault, KDialogBase::No,
              nullptr, "permissiondlg", true, true,
              KGuiItem(i18n("&Allow"), "button_ok"),
              KGuiItem(i18n("&Deny"), "button_cancel")),

  m_vbox(new TQVBox(this)),
  m_hbox(new TQHBox(m_vbox)),
  m_icon(new TQLabel(m_hbox)),
  m_text(new TQLabel(m_hbox)),
  m_detail(new TQLabel(this))

{
    setPlainCaption(i18n("Permission request"));

    TQString text;
    if (!application.isEmpty())
    {
        text = "<qt>Application \"%1\" has requested the following permission: <b>%2</b></qt>";
        text = text.arg(application);
    }
    else
        text = "<qt>An unknown application has requested the following permission: <b>%1</b></qt>";
    m_text->setText(text.arg(feature));

    m_icon->setPixmap(DesktopIcon(icon));

    m_icon->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
    m_text->setSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Fixed);

    TQString detailStr = "<qt><table><tbody>";
    for (Dictionary::iterator it = details.begin(); it != details.end(); ++it)
    {
        detailStr += TQString("<tr><td>%1:</td><td><b>%2</b></td></tr>")
                     .arg(it.key(), it.data());
    }
    detailStr += "</tbody></table></qt>";
    m_detail->setText(detailStr);

    setMainWidget(m_vbox);
    setDetailsWidget(m_detail);

    m_hbox->setSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Fixed);

//     m_vbox->setMargin(KDialogBase::marginHint());
    m_icon->setMargin(KDialogBase::spacingHint());
    m_text->setMargin(KDialogBase::spacingHint());
    raise();
}

TDEPermissionDialog::~TDEPermissionDialog()
{
}

void TDEPermissionDialog::appendWidget(TQWidget *widget)
{
    m_vbox->hide();
    widget->reparent(m_vbox, TQPoint());
    m_vbox->show();
}