/****************************************************************************
** $Id$
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

import org.trinitydesktop.qt.*;

class PictureDisplay extends TQWidget		// picture display widget
{

static void paintCar( TQPainter p )			// paint a car
{
    TQPointArray a = new TQPointArray();
    TQBrush brush = new TQBrush( Qt.yellow(), Qt.SolidPattern );
    p.setBrush( brush );			// use solid, yellow brush

    a.setPoints( 5, new short[] { 50,50, 350,50, 450,120, 450,250, 50,250 } );
    p.drawPolygon( a );			// draw car body

    TQFont f = new TQFont( "courier", 12, TQFont.Bold, false );
    p.setFont( f );

    TQColor windowColor = new TQColor( 120, 120, 255 );	// a light blue color
    brush.setColor( windowColor );		// set this brush color
    p.setBrush( brush );			// set brush
    p.drawRect( 80, 80, 250, 70 );		// car window
    p.drawText( 180, 80, 150, 70, Qt.AlignCenter, "--  Qt  --\nTrolltech AS" );

    TQPixmap pixmap = new TQPixmap();
    if ( pixmap.load("flag.bmp") )		// load and draw image
	p.drawPixmap( 100, 90, pixmap );

    p.setBackgroundMode( Qt.OpaqueMode );		// set opaque mode
    p.setBrush( Qt.DiagCrossPattern );		// black diagonal cross pattern
    p.drawEllipse( 90, 210, 80, 80 );		// back wheel
    p.setBrush( Qt.CrossPattern );		// black cross fill pattern
    p.drawEllipse( 310, 210, 80, 80 );		// front wheel
}



private TQPicture   pict;
private String	name;

public PictureDisplay( String fileName )
{
    pict = new TQPicture();
    name = fileName;
    if ( !pict.load(fileName) ) {		// cannot load picture
	pict = null;
	name = "Not able to load picture: " + fileName;
    }
}

protected void paintEvent( TQPaintEvent event )
{
    TQPainter paint = new TQPainter( this );			// paint widget
    if ( pict != null )
    	paint.drawPicture( pict );		// draw picture
    else
	paint.drawText( rect(), AlignCenter, name );
}

protected void keyPressEvent( TQKeyEvent k )
{
//   switch ( tolower(k.ascii()) ) {
    switch ( k.ascii() ) {
	case 'r':				// reload
	    pict.load( name );
	    update();
	    break;
	case 'q':				// quit
	    TQApplication.exit();
	    break;
    }
}


static public void main( String[] args )
{
    TQApplication a = new TQApplication( args );		// TQApplication required!

    String fileName = "car.pic";			// default picture file name

    if ( args.length == 1 )				// use argument as file name
	fileName = args[0];

    if ( !TQFile.exists(fileName) ) {
	TQPicture pict = new TQPicture();				// our picture
	TQPainter paint = new TQPainter();				// our painter

	paint.begin( pict );			// begin painting onto picture
	paintCar( paint );				// paint!
	paint.end();				// painting done

	pict.save( fileName );			// save picture
	TQMessageBox.information(null, "Qt picture example", "Saved.  Run me again!");
	return;
    } else {
	PictureDisplay test = new PictureDisplay( fileName );		// create picture display
	a.setMainWidget( test);			// set main widget
	test.show();				// show it

	a.exec();				// start event loop
	return;
    }
}

static {
	qtjava.initialize();
}

}

