/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "tde-tqt.h"

#include "kchmdialogchooseurlfromlist.h"
#include "kchmtreeviewitem.h"

KCHMDialogChooseUrlFromList::KCHMDialogChooseUrlFromList(const TQStringList& urls, const TQStringList& titles, TQWidget* parent)
	: TQDialog(parent, 0, true)
{
	TQVBoxLayout * layout = new TQVBoxLayout (this);
	layout->setMargin (5);

	TQListView * m_urlsList = new TQListView (this);
	m_urlsList->addColumn( i18n( "Topics" ) );
	
	for ( unsigned int i = 0; i < urls.size(); i++ )
		new KCHMSingleTreeViewItem (m_urlsList, titles[i], urls[i]);

	layout->addWidget ( new TQLabel( i18n( "Please select one of the topics below:"), this) );
	layout->addWidget ( m_urlsList );

	TQHBoxLayout * hlayout = new TQHBoxLayout (layout);
	TQPushButton * bok = new TQPushButton( i18n( "&Ok" ), this);
	TQPushButton * bcancel = new TQPushButton( i18n( "&Cancel" ), this);

	hlayout->addWidget (bok);
	hlayout->addWidget (bcancel);

	connect( m_urlsList, TQ_SIGNAL( doubleClicked ( TQListViewItem *, const TQPoint &, int) ), this, TQ_SLOT( onDoubleClicked ( TQListViewItem *, const TQPoint &, int) ) );
	connect( m_urlsList, TQ_SIGNAL( currentChanged ( TQListViewItem *) ), this, TQ_SLOT( onCurrentChanged ( TQListViewItem *) ) );
	
	connect( bok, TQ_SIGNAL( clicked () ), this, TQ_SLOT( accept() ) );
	connect( bcancel, TQ_SIGNAL( clicked () ), this, TQ_SLOT( reject() ) );
	m_acceptedurl = TQString();
}

void KCHMDialogChooseUrlFromList::onDoubleClicked( TQListViewItem * , const TQPoint &, int )
{
	accept();
}

void KCHMDialogChooseUrlFromList::onCurrentChanged( TQListViewItem * item )
{
	if ( item )
		m_acceptedurl = ((KCHMSingleTreeViewItem *) item)->getUrl();
	else
		m_acceptedurl = TQString();
}

#include "kchmdialogchooseurlfromlist.moc"
