/***************************************************************************
                          kxeprocinstrdialog.cpp  -  description
                             -------------------
    begin                : Mit Apr 24 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxeprocinstrdialog.h"

#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>
#include <tqtextedit.h>

#include <klineedit.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

KXEProcInstrDialog::KXEProcInstrDialog( TQWidget * pParent, const char * pszName, bool fModal, WFlags fl )
	: KXEProcInstrDialogBase( pParent, pszName, fModal, fl )
{
  // signals and slots connections
  connect( m_pBtnOK, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotAccept() ) );
  connect( m_pEditData, TQ_SIGNAL(textChanged()), this, TQ_SLOT(slotDataChanged()) );
  connect( m_pEditTarget, TQ_SIGNAL(textChanged(const TQString &)), this, TQ_SLOT(slotTargetChanged(const TQString &)) );
}


void KXEProcInstrDialog::clearDialog()
{
	m_pEditTarget->clear();
	m_pEditData->clear();
}


int KXEProcInstrDialog::exec( bool bEditExisting, bool bParentIsDocument )
{
  if(bEditExisting)
  {
    m_pComboInsert->hide();
    m_pComboInsert->setDisabled(true);
    m_pLblInsert->hide();
    m_pLblInsert->setDisabled(true);

    m_pEditTarget->setDisabled(true);

    m_pEditTarget->setText( m_strTarget );
    m_pEditData->setText( m_strData );
  }
  else
  {
    if ( bParentIsDocument )
    {
      m_pComboInsert->hide();
      m_pComboInsert->setDisabled(true);
      m_pLblInsert->hide();
      m_pLblInsert->setDisabled(true);
    }
    m_pEditTarget->setEnabled(true);
    clearDialog();
  }

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
    m_bAtTop = ( m_pComboInsert->currentItem() == 0 );
    m_strTarget = m_pEditTarget->text();
    m_strData = m_pEditData->text();
	}

	return iReturn;
}

int KXEProcInstrDialog::exec()
{
	if ( m_pEditTarget->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);

	if ( m_pEditTarget->isEnabled() )
		m_pEditTarget->setFocus();
	else
		m_pEditData->setFocus();

	m_pBtnOK->setDefault(true);

	return KXEProcInstrDialogBase::exec();
}

void KXEProcInstrDialog::slotDataChanged()
{
	TQString strMessage = checkData(m_pEditData->text());
  if(strMessage.isEmpty())
     strMessage = checkTarget(m_pEditTarget->text());

  m_pTextLabelMessage->setText(strMessage);

	if ( m_pEditData->text().isEmpty()  ||
       m_pEditTarget->text().isEmpty() ||
       (strMessage.length() > 0)
     )
		m_pBtnOK->setDisabled(true);
	else
		m_pBtnOK->setEnabled(true);
}

void KXEProcInstrDialog::slotTargetChanged(const TQString &strNewTarget)
{
	TQString strMessage = checkTarget(strNewTarget);
  if(strMessage.isEmpty())
     strMessage = checkData(m_pEditData->text());

  m_pTextLabelMessage->setText(strMessage);

	if ( m_pEditData->text().isEmpty() ||
       strNewTarget.isEmpty() ||
       (strMessage.length() > 0)
     )
		m_pBtnOK->setDisabled(true);
	else
		m_pBtnOK->setEnabled(true);
}

/** Called when user press OK button */
void KXEProcInstrDialog::slotAccept()
{
  if(m_pEditTarget->text() == "xml")
    { KMessageBox::sorry(this, i18n("Pleasse use menu item File -> Version and encoding for this processing instruction !"));
			return;
		}
  
  accept();
}

// Check, if XML proc. instr. target is OK
TQString KXEProcInstrDialog::checkTarget(const TQString strTarget)
{
  if(strTarget.length() == 0)
    return  "";

  // Forbidden characters
  TQString strForbiddenChars("<>");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    TQChar ch = strForbiddenChars[i];

    if(strTarget.find(ch) >= 0)
      return i18n("Target cannot contain character: %1 !").arg(ch);
  }

  return "";
}

// Check, if XML proc. instr. data is OK
TQString KXEProcInstrDialog::checkData(const TQString strData)
{
  if(strData.length() == 0)
    return  "";

  // Forbidden characters
  TQString strForbiddenChars("<>");
  for(unsigned int i = 0; i < strForbiddenChars.length(); i++)
  {
    TQChar ch = strForbiddenChars[i];

    if(strData.find(ch) >= 0)
      return i18n("Contents cannot contain character: %1 !").arg(ch);
  }

  return "";
}

#include "kxeprocinstrdialog.moc"
