/***************************************************************************
                           kxesettings.cpp
                           ---------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxesettings.h"

#include <tdeconfig.h>

KXESettings::KXESettings( const TQString & strConfigGroup,  TQObject * pParent, const char * pszName )
 : TQObject( pParent, pszName ),
   m_bPageChanged( false ),
   m_strConfigGroup( strConfigGroup )
{
	connect( this, TQ_SIGNAL(sigDialogPageChanged()), this, TQ_SLOT(slotDialogPageChanged()) );
}

void KXESettings::setConfigGroup( TDEConfig * pConfig ) const
{
	pConfig->setGroup( m_strConfigGroup );
}

void KXESettings::store( TDEConfig * pConfig ) const
{
	setConfigGroup( pConfig );
	write( pConfig );
}

void KXESettings::restore( TDEConfig * pConfig )
{
	setConfigGroup( pConfig );
	read( pConfig );

	// update the corresponding config.dialog page
	blockSignals( true ); // block this object's signals (especially sigDialogPageChanged)
	updatePage();
	blockSignals( false ); // unblock the signals

	emit sigChanged();
}

void KXESettings::slotDialogPageChanged()
{
	m_bPageChanged = true;
}

void KXESettings::apply()
{
	if ( m_bPageChanged )
	{
		setFromPage();
		m_bPageChanged = false;
		emit sigChanged();
	}
}

#include "kxesettings.moc"
