/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "fetcher.h"
#include "messagehandler.h"
#include "../entry.h"

#include <tdeglobal.h>
#include <tdeconfig.h>

using Tellico::Fetch::Fetcher;
using Tellico::Fetch::SearchResult;

Fetcher::~Fetcher() {
  TDEConfigGroup config(TDEGlobal::config(), m_configGroup);
  saveConfigHook(config);
}

void Fetcher::readConfig(const TDEConfigGroup& config_, const TQString& groupName_) {
  m_configGroup = groupName_;

  TQString s = config_.readEntry("Name");
  if(!s.isEmpty()) {
    m_name = s;
  }
  m_updateOverwrite = config_.readBoolEntry("UpdateOverwrite", false);
  // be sure to read config for subclass
  readConfigHook(config_);
}

void Fetcher::message(const TQString& message_, int type_) const {
  if(m_messager) {
    m_messager->send(message_, static_cast<MessageHandler::Type>(type_));
  }
}

void Fetcher::infoList(const TQString& message_, const TQStringList& list_) const {
  if(m_messager) {
    m_messager->infoList(message_, list_);
  }
}

void Fetcher::updateEntry(Data::EntryPtr) {
  emit signalDone(this);
}

Tellico::Data::EntryPtr SearchResult::fetchEntry() {
  return fetcher->fetchEntry(uid);
}

#include "fetcher.moc"
