/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Tue Aug 13 09:31:50 EST 2002
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optushome.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */
#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kurl.h>
#include <tdemessagebox.h>

/* QT INCLUDES */
#include <tqapplication.h>
#include <tqobject.h>
#include <tqstring.h>

/* OTHER INCLUDES */
#include <cstdio>
#include <cstdlib>
#include "instance.h"
#include <iostream>
#include <kommanderversion.h>

using std::cout;
using std::endl;
using std::cerr;


static const char *description =
	I18N_NOOP("Executor is a component of the Kommander dialog system that executes .kmdr files given as arguments or via stdin");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE

static TDECmdLineOptions options[] =
{
  { "!stdin", I18N_NOOP("Read dialog from standard input"), 0},
  { "c <catalog>", I18N_NOOP("Use given catalog for translation"), 0},      
  { "+[file]", I18N_NOOP("Dialog to open"), 0 },
  TDECmdLineLastOption
};

int main(int argc, char *argv[])
{
  TDEAboutData aboutData( "kmdr-executor", I18N_NOOP("Kommander Executor"),
    KOMMANDER_VERSION, description, TDEAboutData::License_GPL,
    "(c) 2002, Marc Britton, (C) 2008 Andras Mantia", 0, 0, "http://kommander.kdewebdev.org");
  aboutData.addAuthor("Andras Mantia", I18N_NOOP("Current maintainer"), "amantia@kdewebdev.org");
  aboutData.addAuthor("Michal Rudolf", I18N_NOOP("Previous maintainer"), "mrudolf@kdewebdev.org");
  aboutData.addAuthor("Marc Britton", I18N_NOOP("Original author"), "consume@optusnet.com.au");
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if (args->isSet("c"))
    TDELocale::setMainCatalogue(args->getOption("c"));
  else if (args->count())
  {
    char buf[200];
    TQString baseFile = args->url(0).fileName();
    int ext = baseFile.findRev('.');
    if (ext != -1)
      baseFile = baseFile.left(ext);
    strcpy(buf, baseFile.latin1());
    TDELocale::setMainCatalogue(buf);
  }
  else
    TDELocale::setMainCatalogue("kommander");
  TDEApplication app;

  TQObject::connect(&app, TQ_SIGNAL(lastWindowClosed()), &app, TQ_SLOT(quit()));
  if (!args->count())
  {
    KMessageBox::sorry(0, i18n("Error: no dialog given. Use --stdin option to read dialog from standard input.\n"));
    return -1;
  }
  Instance instance;
  if (!instance.build(args->isSet("stdin") ? TQString() : args->url(0)))
    return -1;

  // Read command-line variables
  TQStringList cmdargs;
  for (int i = !args->isSet("stdin"); i<args->count(); i++)
    cmdargs.append(args->arg(i));
  instance.addCmdlineArguments(cmdargs);

  instance.run();
  return 0;
}
