//
// C++ Interface: filterlogview
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FILTERLOGVIEW_H
#define FILTERLOGVIEW_H

//TQt headers
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>

//KDE headers
#include <kdialogbase.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <kseparator.h>

//KShowmail headers
#include "filterlog.h"
#include "filterlogviewdeleteditem.h"
#include "filterlogviewmoveditem.h"

/**
 * @brief This dialog box shows the filter log.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class FilterLogView : public KDialogBase
{

TQ_OBJECT

  public:

    /**
     * General constructor
     * @param parent pointer to the parent widget
     * @param log pointer to the filter log
     */
    FilterLogView( TQWidget* parent = NULL, FilterLog* log = NULL );

    /**
     * Destructor
     */
    ~FilterLogView();

  private:

    /**
     * Pointer to the filter log.
     */
    FilterLog* log;

    /**
     * List view of deleted mails
     */
    TDEListView* lstViewDeleted;

    /**
     * List view of moved mails
     */
    TDEListView* lstViewMoved;

  private slots:

    /**
     * Clears the list of deleted mails.
     */
    void slotClearDeletedMails();

    /**
     * Clears th elist of moved mails.
     */
    void slotClearMovedMails();

};

#endif
