/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_SPINX_TOOL_BUTTON_H
#define KBFX_SPINX_TOOL_BUTTON_H

#include <tqcursor.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqtimer.h>
#include <tqtoolbutton.h>
#include <tqwidget.h>

#include <kiconloader.h>
#include <kimageeffect.h>
#include <krun.h>

#include <kbfxconfig.h>
#include <kbfxdatagroup.h>
#include <kbfxdatasource.h>
#include <kbfxplasmapixmapprovider.h>

class KbfxSpinxToolButton:public TQLabel
{

		TQ_OBJECT
  
	public:
		typedef enum{SINGLE=0,EXPANDABLE} ButtonType;

		KbfxSpinxToolButton ( TQWidget * parent = 0, const char * name = 0 );
		virtual	~KbfxSpinxToolButton();
		virtual void paintEvent ( TQPaintEvent * pe );

		virtual void enterEvent ( TQEvent * e );
		virtual void leaveEvent ( TQEvent * l );
		virtual void mouseReleaseEvent ( TQMouseEvent * me );
		/*
		virtual void mousePressEvent(TQMouseEvent * me);
		*/
		void setDataSource ( KbfxDataSource * src );
//	void setDataGroup(KbfxDataGroup * gsrc);
		void setName ( TQString name ) {m_name =name;}
		void setExec ( TQString cmd ) { m_exe = cmd;}
		void setType ( KbfxSpinxToolButton::ButtonType type ) { m_type = type;}
		void setIcon ( TQString path );
		void setPixmaps ( TQPixmap , TQPixmap );

	public slots:
		void fade();

	signals:
		void clicked();
	private:
		TQString m_name;
		TQString m_exe;
		TQString m_icon;
		TQString m_tooltip;

		TQPixmap m_normal;
		TQPixmap m_pressed;
		TQPixmap m_hover;
		TQPixmap m_current;
		TQPixmap m_iconPixmap;
		KbfxDataSource * m_dataSource;
		KbfxDataGroup  * m_dataGroup;
		ButtonType m_type;
		bool m_statePressed;
		TQTimer * fade_timer;
		float m_opacity;
		TQPixmap m_fadePix;
		int m_fadeTime;
};

#endif
