###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


##### check for ocaml/facile

if( WITH_OCAML_SOLVER )

  if( NOT DEFINED HAVE_OCAML )
    message( STATUS "Search for ocaml" )

    foreach( _exec ocamlc ocamldep ocamlopt )
      string( TOUPPER "${_exec}_EXECUTABLE" _exec_var )
      if( NOT DEFINED ${_exec_var} )
        find_program( ${_exec_var} NAMES ${_exec} )
        if( NOT ${_exec_var} )
          tde_message_fatal( "${_exec} is requested, but was not found on your system" )
        endif( )
      endif( )
    endforeach( )

    if( NOT DEFINED OCAML_BASEDIR )
      execute_process(
        COMMAND ${OCAMLOPT_EXECUTABLE} -where
        OUTPUT_VARIABLE OCAML_BASEDIR
        ERROR_VARIABLE OCAML_BASEDIR
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
      )
      if( EXISTS ${OCAML_BASEDIR} AND IS_DIRECTORY ${OCAML_BASEDIR} )
        set( OCAML_BASEDIR ${OCAML_BASEDIR} CACHE PATH "Ocaml base directory" )
        set( OCAML_LIBRARY_DIR ${OCAML_BASEDIR} CACHE PATH "Ocaml libraries directory" )
      else( )
        tde_message_fatal( "Ocaml is requested, but was not found on your system" )
      endif( )
    endif( )

    set( HAVE_OCAML 1 CACHE INTERNAL "" )
    message( STATUS "Search for ocaml - found" )
  endif( )


  if( NOT DEFINED HAVE_FACILE )
    message( STATUS "Search for facile" )

    if( NOT DEFINED FACILE_LIBRARIES )
      find_library( FACILE_LIBRARIES
        NAMES facile.a
        HINTS ${OCAML_BASEDIR}
        PATH_SUFFIXES facile ocaml/facile
      )
    endif( )

    if( NOT DEFINED FACILE_INCLUDE_DIR )
      find_path( FACILE_INCLUDE_DIR
          NAMES facile.cmi
          HINTS ${OCAML_BASEDIR}
          PATH_SUFFIXES facile lib/ocaml/facile
      )
    endif( )

    if( (NOT FACILE_LIBRARIES) OR (NOT FACILE_INCLUDE_DIR) )
      tde_message_fatal( "Facile is requested, but was not found on your system" )
    endif( )

    set( HAVE_FACILE 1 CACHE INTERNAL "Enable build with ocaml/facile" )
    message( STATUS "Search for facile - found" )
  endif( )

endif( WITH_OCAML_SOLVER )
