/***************************************************************************
                         kgrcanvas.h  -  description
                             -------------------
    begin                : Wed Jan 23 2002
    copyright            : (C) 2002 by Marco Krger and Ian Wadham
    email                : See menu "Help, About KGoldrunner"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRCANVAS_H
#define KGRCANVAS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqcursor.h>
#include <tqcanvas.h>
#include <tqlabel.h>
#include <tqimage.h>
#include <tqpainter.h>

class KGrCanvas : public TQCanvasView
{
	TQ_OBJECT
  
public:
	KGrCanvas (TQWidget * parent = 0, const char *name = 0);
	virtual ~KGrCanvas();

	void changeLandscape (const TQString & name);

	TQPoint getMousePos ();
	void setMousePos (int, int);

	bool changeSize (int);
	void setBaseScale ();

	void updateCanvas ();
	void paintCell (int, int, char, int offset = 0);
	void setTitle (TQString);

	void makeHeroSprite (int, int, int);
	void setHeroVisible (bool);
	void moveHero (int, int, int);

	void makeEnemySprite (int, int, int);
	void moveEnemy (int, int, int, int, int);
	void deleteEnemySprites();

	TQPixmap getPixmap (char type);

signals:
	void mouseClick (int);
	void mouseLetGo (int);

protected:
	void contentsMousePressEvent (TQMouseEvent *);
	void contentsMouseReleaseEvent (TQMouseEvent *);

private:
	TQCursor * m;

	TQCanvas * field;
	TQCanvasView * fieldView;
	int scaleStep;			// Current scale-factor of canvas.
	int baseScale;			// Starting scale-factor of canvas.
	int baseFontSize;

	int border;			// Number of tiles allowed for border.
	int cw, bw, lw, mw;		// Dimensions (in pixels) of the border.
	TQColor borderColor, textColor;	// Border colours.
	TQLabel * title;			// Title and top part of border.
	TQCanvasRectangle * borderB;	// Bottom part of border.
	TQCanvasRectangle * borderL;	// Left-hand part of border.
	TQCanvasRectangle * borderR;	// Right-hand part of border.

	int freebg, nuggetbg, polebg, ladderbg, hladderbg;
	int edherobg, edenemybg, betonbg, brickbg, fbrickbg;
	int bgw, bgh, bgd;
	TQPixmap bgPix;

	TQCanvasPixmapArray * heroArray;
	TQCanvasPixmapArray * enemyArray;
	int goldEnemy;

	TQCanvasSprite * heroSprite;
#ifdef QT3
	TQPtrList<TQCanvasSprite> * enemySprites;
#else
	TQPtrList<TQCanvasSprite> * enemySprites;
#endif

	void initView();
	void makeTiles();
	void makeBorder();
	void makeTitle();
	TQColor colour;
	TQCanvasRectangle * drawRectangle (int, int, int, int, int);
	void changeColours (const char * colours []);
	void recolourObject (const char * object [], const char * colours []);
};

#endif // KGRCANVAS_H
