//
// C++ Implementation: taskviewwhatsthis
//
// Description: 
// This is a subclass of TQWhatsThis, specially adapted for karm's taskview.
//
// Author: Thorsten Staerk <thorsten@staerk.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "taskviewwhatsthis.h"
#include <kdebug.h>
#include <tdelistview.h>
#include <tdelocale.h>

TaskViewWhatsThis::TaskViewWhatsThis( TQWidget* qw )
 : TQWhatsThis( qw )
{
  _listView=(TDEListView *) qw;
}

TaskViewWhatsThis::~TaskViewWhatsThis()
{
}

TQString TaskViewWhatsThis::text ( const TQPoint & pos )
{
  TQString desc = TQString();
  kdDebug(5970) << "entering TaskViewWhatsThis::text" << endl;
  kdDebug(5970) << "x-pos:" << pos.x() << endl;
  if ( pos.x() < _listView->columnWidth( 0 ) ) 
  {
    desc=i18n("Task Name shows the name of a task or subtask you are working on.");
  }
  else
  {
    desc=i18n("Session time: Time for this task since you chose \"Start New Session\".\nTotal Session time: Time for this task and all its subtasks since you chose \"Start New Session\".\nTime: Overall time for this task.\nTotal Time: Overall time for this task and all its subtasks.");
  }
  return desc;
}
