/*******************************************************************************
**
** Filename   : foldershortcutdialog.cpp
** Created on : 09 October, 2004
** Copyright  : (c) 2004 Till Adam
** Email      : adam@kde.org
**
*******************************************************************************/

/*******************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program; if not, write to the Free Software
**   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
**
**   In addition, as a special exception, the copyright holders give
**   permission to link the code of this program with any edition of
**   the TQt library by Trolltech AS, Norway (or with modified versions
**   of TQt that use the same license as TQt), and distribute linked
**   combinations including the two.  You must obey the GNU General
**   Public License in all respects for all of the code used other than
**   TQt.  If you modify this file, you may extend this exception to
**   your version of the file, but you are not obligated to do so.  If
**   you do not wish to do so, delete this exception statement from
**   your version.
**
*******************************************************************************/

#include <tqlabel.h>
#include <tqvbox.h>
#include <tqvgroupbox.h>
#include <tqwhatsthis.h>

#include <kkeybutton.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

#include "kmmainwidget.h"
#include "foldershortcutdialog.h"
#include "kmfolder.h"

using namespace KMail;

FolderShortcutDialog::FolderShortcutDialog( KMFolder *folder,
                                            KMMainWidget *mainwidget,
                                            TQWidget *parent,
                                            const char *name )
:  KDialogBase( parent, name, true,
               i18n( "Shortcut for Folder %1" ).arg( folder->label() ),
               KDialogBase::Ok | KDialogBase::Cancel ),
   mFolder( folder ), mMainWidget( mainwidget )
{
  TQVBox *box = makeVBoxMainWidget();
  TQVGroupBox *gb = new TQVGroupBox( i18n("Select Shortcut for Folder"), box );
  TQWhatsThis::add( gb, i18n( "<qt>To choose a key or a combination "
                             "of keys which select the current folder, "
                             "click the button below and then press the key(s) "
                             "you wish to associate with this folder.</qt>" ) );
  TQHBox *hb = new TQHBox( gb );
  new TQWidget(hb);
  mKeyButton = new KKeyButton( hb, "FolderShortcutSelector" );
  new TQWidget(hb);

  connect( mKeyButton, TQ_SIGNAL( capturedShortcut( const TDEShortcut& ) ),
           this, TQ_SLOT( slotCapturedShortcut( const TDEShortcut& ) ) );
  mKeyButton->setShortcut( folder->shortcut(), false );
}

FolderShortcutDialog::~FolderShortcutDialog()
{
}

void FolderShortcutDialog::slotCapturedShortcut( const TDEShortcut& sc )
{
  if ( sc == mKeyButton->shortcut() ) return;
  if ( sc.toString().isNull() ) {
    // null is fine, that's reset, but sc.іsNull() will be false :/
    mKeyButton->setShortcut( TDEShortcut::null(), false );
  } else {
    if( !mMainWidget->shortcutIsValid( sc ) ) {
      TQString msg( i18n( "The selected shortcut is already used, "
            "please select a different one." ) );
      KMessageBox::sorry( mMainWidget, msg );
    } else {
      mKeyButton->setShortcut( sc, false );
    }
  }
}

void FolderShortcutDialog::slotOk()
{
  mFolder->setShortcut( mKeyButton->shortcut() );
  KDialogBase::slotOk();
}

#include "foldershortcutdialog.moc"


