/*=========================================================================
| KCardDAV
|--------------------------------------------------------------------------
| (c) 2010  Timothy Pearson
|
| This project is released under the GNU General Public License.
| Please see the file COPYING for more details.
|--------------------------------------------------------------------------
| CardDAV resource factory.
 ========================================================================*/

/*=========================================================================
| INCLUDES
 ========================================================================*/

#include "resource.h"
#include "config.h"
#include "export.h"

#include <tdeglobal.h>
#include <tdelocale.h>

/*=========================================================================
| NAMESPACE
 ========================================================================*/

using namespace TDEABC;

/*=========================================================================
| CLASS
 ========================================================================*/

// Creates the resource factory.

typedef KRES::PluginFactory<ResourceCardDav, ResourceCardDavConfig> CardDavFactory;

extern "C"
{
  void *init_tdeabc_carddav()
  {
    TDEGlobal::locale()->insertCatalogue( "tdepimresources" );
    TDEGlobal::locale()->insertCatalogue( "kres_caldav" );
    return new CardDavFactory;
  }
}

// EOF ========================================================================
