/***************************************************************************
*   Copyright (C) 2005 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>

#include <tqstring.h>

#include <iostream>
using std::cout;
using std::endl;

#include "mmfimporter.h"
#include "mmfexporter.h"
#include "importertest.h"
#include "exportertest.h"

int
main(int argc, char *argv[])
{
	TDEAboutData *about = new TDEAboutData("mmftest", I18N_NOOP("mmftest"), "1.0",
	        nullptr, TDEAboutData::License_GPL, nullptr, nullptr, nullptr, nullptr);
	TDECmdLineArgs::init(argc, argv, about);
	TDEApplication::disableAutoDcopRegistration(); // will reduce noise when we run without X11
	TDEApplication a(/* allowStyles =*/ false, /* GUIenabled =*/ false);

	printf("Creating MMFImporter.\n");
	MMFImporter importer;

	printf("Parsing mmftest.txt.\n");
	TQStringList files; files << "mmftest.txt";
	importer.parseFiles(files);

	Recipe recipe;
	recipe.title = "Cookies_Test";
	recipe.yield.amount = 2;
	recipe.yield.type = "servings";
	recipe.categoryList.append( Element("Snacks",1) );
	recipe.categoryList.append( Element("Cookies & Squares",2) );
	recipe.instructions = 
		"Drop by spoonful on greased cookie sheet.  Bake in moderate oven.";
	recipe.prepTime = TQTime(0,30);

	Ingredient ing9;
	ing9.name = "a";
	ing9.amount = 1;
	ing9.amount_offset = 0;
	ing9.units.name = "cup";
	IngredientData ing9_1;
	ing9_1.name = "b";
	ing9_1.amount = 2;
	ing9_1.amount_offset = 0;
	ing9_1.units.plural = "cups";
	IngredientData ing9_2;
	ing9_2.name = "c";
	ing9_2.amount = 3;
	ing9_2.amount_offset = 0;
	ing9_2.units.plural = "cups";
	ing9.substitutes.append(ing9_1);
	ing9.substitutes.append(ing9_2);
	recipe.ingList.append( ing9 );

	Ingredient ing2;
	ing2.name = "c. granulated sugar";
	ing2.amount = 0.75;
	ing2.groupID = 0; ing2.group = "Dry Ingredients";
	recipe.ingList.append( ing2 );

	Ingredient ing;
	ing.name = "c. brown sugar";
	ing.amount = 1;
	ing.amount_offset = 0;
	ing.groupID = 0; ing.group = "Dry Ingredients";
	recipe.ingList.append( ing );

	Ingredient ing3;
	ing3.name = "c. all-purpose flour";
	ing3.amount = 2;
	ing3.groupID = 0; ing3.group = "Dry Ingredients";
	recipe.ingList.append( ing3 );

	Ingredient ing4;
	ing4.name = "tsp. baking soda";
	ing4.amount = 1;
	ing4.groupID = 0; ing4.group = "Dry Ingredients";
	recipe.ingList.append( ing4 );

	Ingredient ing8;
	ing8.name = "c. shortening";
	ing8.amount = 1;
	ing8.prepMethodList.append( Element("softened") );
	ing8.prepMethodList.append( Element("at room temperature") );
	ing8.groupID = 1; ing8.group = "Fat & Liquids";
	recipe.ingList.append( ing8 );

	Ingredient ing6;
	ing6.name = "c. peanut butter";
	ing6.amount = 1;
	ing6.groupID = 1; ing6.group = "Fat & Liquids";
	recipe.ingList.append( ing6 );

	Ingredient ing5;
	ing5.name = "eggs";
	ing5.amount = 2;
	ing5.groupID = 1; ing5.group = "Fat & Liquids";
	recipe.ingList.append( ing5 );

	Ingredient ing7;
	ing7.name = "tsp. vanilla extract";
	ing7.amount = 1;
	ing7.groupID = 1; ing7.group = "Fat & Liquids";
	recipe.ingList.append( ing7 );

	check( importer, recipe );

	RecipeList recipeList;
	recipeList.append(recipe);
	recipeList.append(recipe);

	printf("Creating MMFExporter.\n");
	MMFExporter exporter("not needed",".mmf");
	const char *outfile = "mmftest_output.txt";
	check( outfile, exporter, recipeList );
	printf("Successfully exported recipes to test.txt.\n");

	printf("Creating MMFImporter to test exported recipes.\n");
	MMFImporter importer2;

	printf("Parsing %s.\n", outfile);
	TQStringList files2; files2 << TQString(outfile);
	importer2.parseFiles(files2);
	check( importer2, recipe );
	printf("Recipe export successful.\n");

	printf("*** MM format importer and exporter passed the tests :-) ***\n");
}
