/* This file is part of the KDE project
   Copyright (C) 1999-2005 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/


#include "kspread_dlg_find.h"
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tdelocale.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqcombobox.h>

using namespace KSpread;

FindOption::FindOption( TQWidget *parent)
{
    TQVBoxLayout *layout = new TQVBoxLayout(parent);
    m_moreOptions = new TQPushButton( i18n( "More Options" ), parent );
    layout->addWidget(  m_moreOptions );

    connect( m_moreOptions, TQ_SIGNAL( clicked () ), this, TQ_SLOT( slotMoreOptions() ) );

    m_findExtension = new TQWidget( parent );
    layout->addWidget( m_findExtension );
    TQVBoxLayout *layout1 = new TQVBoxLayout( m_findExtension );
    m_searchInAllSheet = new TQCheckBox( i18n( "Search entire sheet" ),m_findExtension );
    layout1->addWidget( m_searchInAllSheet );

    TQHBoxLayout *comboLayout = new TQHBoxLayout( m_findExtension );
    TQLabel *label = new TQLabel( i18n( "Search in:" ), m_findExtension );
    comboLayout->addWidget( label );

    m_searchIn = new TQComboBox( m_findExtension );
    comboLayout->addWidget( m_searchIn );
    layout1->addLayout( comboLayout );

    TQStringList lst;
    lst << i18n( "Cell Values" );
    lst << i18n( "Comments" );
    m_searchIn->insertStringList( lst );

    comboLayout = new TQHBoxLayout( m_findExtension );
    label = new TQLabel( i18n( "Search direction:" ), m_findExtension );
    comboLayout->addWidget( label );

    m_searchDirection = new TQComboBox( m_findExtension );
    comboLayout->addWidget( m_searchDirection );
    layout1->addLayout( comboLayout );

    lst.clear();
    lst << i18n( "Across then Down" );
    lst << i18n( "Down then Across" );
    m_searchDirection->insertStringList( lst );

    m_findExtension->hide();
    emit adjustSize();
}

FindOption::searchTypeValue FindOption::searchType() const
{
    int pos = m_searchIn->currentItem();
    if ( pos == 0 )
        return Value;
    else if ( pos == 1 )
        return Note;
    else
        return Value;
}

FindOption::searchDirectionValue FindOption::searchDirection() const
{
    int pos = m_searchDirection->currentItem();
    if ( pos == 0 )
        return Row;
    else if ( pos == 1 )
        return Column;
    else
        return Row;
}


void FindOption::slotMoreOptions()
{
    if ( m_findExtension->isHidden() )
    {
        m_findExtension->show();
        m_moreOptions->setText( i18n( "Fewer Options" ));
    }
    else
    {
        m_findExtension->hide();
        m_moreOptions->setText( i18n( "More Options" ));
    }
    emit adjustSize();
}

bool FindOption::searchInAllSheet() const
{
    return m_searchInAllSheet->isChecked();
}

FindDlg::FindDlg(TQWidget *parent, const char *name, long options, const TQStringList &findStrings, bool hasSelection )
    : KFindDialog(parent,name,options,findStrings,hasSelection  )
{
    m_findOptions = new FindOption( findExtension() );
    connect( m_findOptions, TQ_SIGNAL( adjustSize() ), TQ_SLOT( slotAjustSize() ) );
    setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum));
}

FindDlg::~FindDlg()
{
  // no need to delete child widgets, TQt does it all for us
}

void FindDlg::slotAjustSize()
{
    adjustSize();
}

bool FindDlg::searchInAllSheet() const
{
    return m_findOptions->searchInAllSheet();
}


SearchDlg::SearchDlg(TQWidget *parent, const char *name, long options, const TQStringList &findStrings, const TQStringList &replaceStrings, bool hasSelection )
    : KReplaceDialog(parent,name,options,findStrings,replaceStrings,hasSelection  )
{
    m_findOptions = new FindOption( findExtension() );
    connect( m_findOptions, TQ_SIGNAL( adjustSize() ), TQ_SLOT( slotAjustSize() ) );
    setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum));
}

SearchDlg::~SearchDlg()
{
  // no need to delete child widgets, TQt does it all for us
}

void SearchDlg::slotAjustSize()
{
    adjustSize();
    setFixedSize(size());
}

bool SearchDlg::searchInAllSheet() const
{
    return m_findOptions->searchInAllSheet();
}


#include "kspread_dlg_find.moc"
