/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _LOG_LINE_TREE_H_
#define _LOG_LINE_TREE_H_

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqmap.h>

#include <kdebug.h>

#include "logLineList.h"

#include "logViewColumn.h"

#include "parentLogLine.h"

//Try to find a impossible type
#define PARENT_LOG_LINE_TYPE 7777

/**
 * @author Nicolas Ternisien
 */
class LogLineTree : public LogLineList {
	public:
		LogLineTree(LogViewColumns* cols, groupByType type, int column=-1);
		
		virtual ~LogLineTree();

		virtual bool remove(LogLine* line);
		virtual void insert(LogLine* line);

	protected:
		TQPtrList<ParentLogLine> parents;
		
		groupByType groupBy;
		int groupByColumn;
		
		LogViewColumns* columns;
		
		/**
		 * Synchronize the lines to delete
		 */
		virtual void synchronizeRemovedLines(View* view);
		
		/**
		 * Synchronize new lines and returns the last one
		 */
		virtual LogLine* synchronizeAddedLines(View* view);

};

#endif
