/***************************************************************************
                          kget_plug_in.cpp  -  description
                             -------------------
    begin                : Wed Jul  3 22:09:28 CEST 2002
    copyright            : (C) 2002 by Patrick
    email                : pch@valleeurpe.net

    Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kget_plug_in.h"

#include <dcopref.h>
#include <kdatastream.h>
#include <kdebug.h>
#include <tdehtml_part.h>
#include <kiconloader.h>
#include <tdeglobal.h>
#include <tdeaction.h>
#include <tdeinstance.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <krun.h>

#include <dom/html_document.h>
#include <dom/html_misc.h>
#include <dom/dom_element.h>

#include <tdeparts/partmanager.h>

#include <set>

#include "links.h"
#include "kget_linkview.h"

KGet_plug_in::KGet_plug_in( TQObject* parent, const char* name )
    : Plugin( parent, name )
{
    TQPixmap pix = TDEGlobal::iconLoader()->loadIcon("kget",
                                                  TDEIcon::MainToolbar);
    TDEActionMenu *menu = new TDEActionMenu( i18n("Download Manager"), pix,
                                         actionCollection(), "kget_menu" );
    menu->setDelayed( false );
    connect( menu->popupMenu(), TQ_SIGNAL( aboutToShow() ), TQ_SLOT( showPopup() ));

    m_paToggleDropTarget=new TDEToggleAction(i18n("Show Drop Target"),
                                           TDEShortcut(),
                                           this, TQ_SLOT(slotShowDrop()),
                                           actionCollection(), "show_drop" );

    menu->insert( m_paToggleDropTarget );

    TDEAction *action = new TDEAction(i18n("List All Links"), TDEShortcut(),
                                  this, TQ_SLOT( slotShowLinks() ),
                                  actionCollection(), "show_links");
    menu->insert( action );

    p_dcopServer= new DCOPClient();
    p_dcopServer->attach ();
}


KGet_plug_in::~KGet_plug_in()
{
    p_dcopServer->detach();
    delete p_dcopServer;
}


void KGet_plug_in::showPopup()
{
    bool hasDropTarget = false;

    if (p_dcopServer->isApplicationRegistered ("kget"))
    {
        DCOPRef kget( "kget", "KGet-Interface" );
        hasDropTarget = kget.call( "isDropTargetVisible" );
    }

    m_paToggleDropTarget->setChecked( hasDropTarget );
}

void KGet_plug_in::slotShowDrop()
{
    if (!p_dcopServer->isApplicationRegistered ("kget"))
        KRun::runCommand("kget --showDropTarget");
    else
    {
        DCOPRef kget( "kget", "KGet-Interface" );
        kget.send( "setDropTargetVisible", m_paToggleDropTarget->isChecked());
    }
}

void KGet_plug_in::slotShowLinks()
{
    if ( !parent() || !parent()->inherits( "TDEHTMLPart" ) )
        return;

    TDEHTMLPart *htmlPart = static_cast<TDEHTMLPart*>( parent() );
    KParts::Part *activePart = 0L;
    if ( htmlPart->partManager() )
    {
        activePart = htmlPart->partManager()->activePart();
        if ( activePart && activePart->inherits( "TDEHTMLPart" ) )
            htmlPart = static_cast<TDEHTMLPart*>( activePart );
    }

    DOM::HTMLDocument doc = htmlPart->htmlDocument();
    if ( doc.isNull() )
        return;

    DOM::HTMLCollection links = doc.links();

    TQPtrList<LinkItem> linkList;
    std::set<TQString> dupeCheck;
    for ( uint i = 0; i < links.length(); i++ )
    {
        DOM::Node link = links.item( i );
        if ( link.isNull() || link.nodeType() != DOM::Node::ELEMENT_NODE )
            continue;

        LinkItem *item = new LinkItem( (DOM::Element) link );
        if ( item->isValid() &&
             dupeCheck.find( item->url.url() ) == dupeCheck.end() )
        {
            linkList.append( item );
            dupeCheck.insert( item->url.url() );
        }
        else
            delete item;
    }

    if ( linkList.isEmpty() )
    {
        KMessageBox::sorry( htmlPart->widget(),
            i18n("There are no links in the active frame of the current HTML page."),
            i18n("No Links") );
        return;
    }

    KGetLinkView *view = new KGetLinkView();
    TQString url = doc.URL().string();
    view->setPageURL( url );

    view->setLinks( linkList );
    view->show();
}

KPluginFactory::KPluginFactory( TQObject* parent, const char* name )
        : KLibFactory( parent, name )
{
    s_instance = new TDEInstance("KPluginFactory");
}

TQObject* KPluginFactory::createObject( TQObject* parent, const char* name, const char*, const TQStringList & )
{
    TQObject *obj = new KGet_plug_in( parent, name );
    return obj;
}

KPluginFactory::~KPluginFactory()
{
    delete s_instance;
}

extern "C"
{
    TDE_EXPORT void* init_tdehtml_kget()
    {
        TDEGlobal::locale()->insertCatalogue("kget");
        return new KPluginFactory;
    }

}

TDEInstance* KPluginFactory::s_instance = 0L;

#include "kget_plug_in.moc"
