# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

MY_PV="${PV}-3"
DESCRIPTION="A quick-n-dirty BSD licensed clone of the GNU libc backtrace facility"
HOMEPAGE="https://www.freshports.org/devel/libexecinfo"
SRC_URI="https://github.com/mikroskeem/${PN}/archive/refs/tags/${PV}.tar.gz -> ${PN}-${MY_PV}.tar.gz"

LICENSE="BSD-2"
SLOT="0"
KEYWORDS="~amd64"
IUSE="static-libs"

src_prepare() {
	default

	sed -i -e 's/CC=/CC?=/' \
		-e 's/AR=/AR?=/' \
		Makefile || die
}

src_install() {
	einstalldocs

	doheader execinfo.h
	doheader stacktraverse.h
	use static-libs && dolib.a libexecinfo.a
	dolib.so libexecinfo.so.1
	dosym ./libexecinfo.so.1 /usr/"$(get_libdir)"/libexecinfo.so
}
