# Copyright 2022-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
PYTHON_COMPAT=( python3_{11..14} )

inherit trinity-base-2 python-single-r1 flag-o-matic

DESCRIPTION="TQt bindings for Python"
HOMEPAGE="https://trinitydesktop.org/"
LICENSE="GPL-2"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="examples"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~dev-python/sip4-tqt-${PV}[${PYTHON_SINGLE_USEDEP}]
	~x11-libs/tqscintilla-${PV}
	~dev-tqt/tqtinterface-${PV}
"
RDEPEND="${DEPEND}"

TQBASE="/usr/tqt3"
BUILD_DIR="${S}"

PATCHES=(
	"${FILESDIR}/${P}-Changing-string-types-to-bytes-for-pytquic.patch"
	"${FILESDIR}/${P}-Fix-FTBFS-with-Python-3.13.patch"
)

src_prepare() {
	default
}

src_configure() {
	append-cflags "-I/usr/include/tqt -I/${TQBASE}/include"
	append-cxxflags "-I/usr/include/tqt -I/${TQBASE}/include"
	local myconf
	myconf=(
	-g "${TQBASE}/include"
	-q "${TQBASE}"
	-y tqt-mt
	-o "${TQBASE}/$(get_libdir)" -u -j 10
	-d "$(python_get_sitedir)/PyTQt"
	-v "${TQBASE}/sip/tqt"
	-b "${TQBASE}/bin"
	-w
	)
	echo yes | "${EPYTHON}" configure.py "${myconf[@]}" CFLAGS="${CFLAGS}" CXXFLAGS="${CXXFLAGS}"|| die
}

src_compile() {
	emake
}

src_install() {
	emake install DESTDIR="${D}"
	if use examples ; then
		insinto "${TQBASE}/share/pytqt/examples"
		doins examples/*
		local EDIR
		for EDIR in SQL canvas i18n webbrowser
		do
			insinto "${TQBASE}/share/pytqt/examples/${EDIR}"
			doins "examples/${EDIR}"/*
		done
	fi
	python_optimize
}
