# Copyright 2022-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

PYTHON_COMPAT=( python3_{11..13} )

TRINITY_MODULE_NAME="tdeedu"
TRINITY_MODULE_TYPE="core"
inherit trinity-meta-2 python-single-r1

DESCRIPTION="Interactive geometry program for TDE"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="scripting"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="
	${PYTHON_DEPS}
	scripting? (
		$(python_gen_cond_dep '
			dev-libs/boost[python,${PYTHON_USEDEP}]
		')
	)
"
RDEPEND="${DEPEND}"
BDEPEND="handbook? (
	app-text/doxygen[dot]
	dev-texlive/texlive-latex
)"

PATCHES=(
	"${FILESDIR}/${P}-fix-build-without-scripting.patch"
)

pkg_setup() {
	python_setup
	trinity-meta-2_pkg_setup
}

src_prepare() {
	sed -i -e '/add_subdirectory( applnk    )/d' \
	-e '/add_subdirectory( libtdeedu )/d' "${S}/CMakeLists.txt" || die

	trinity-meta-2_src_prepare
}

src_configure() {
	local mycmakeargs=(
		"-DPython_EXECUTABLE=${PYTHON}"
		"-DWITH_KIG_PYTHON_SCRIPTING=$(usex scripting)"
	)

	trinity-meta-2_src_configure
}
