#!/bin/bash

rpm -Uvh http://download.opensuse.org/source/distribution/leap/15.5/repo/oss/src/perl-PAR-Packer-1.057-bp155.1.4.src.rpm \
 && rpmbuild -bb ${HOME}/rpmbuild/SPECS/perl-PAR-Packer.spec \
 && sudo rpm -Uvh "${HOME}/rpmbuild/RPMS/"*"/perl-PAR-Packer"*".rpm"

# Install heimdal development files
rpm -Uvh https://ftp.lysator.liu.se/pub/opensuse/source/distribution/leap/15.6/repo/oss/src/libheimdal-7.8.0-bp156.4.4.src.rpm \
 && wget -nv -O "${HOME}/rpmbuild/SOURCES/heimdal-7.8.0.tar.gz" "https://github.com/heimdal/heimdal/releases/download/heimdal-7.8.0/heimdal-7.8.0.tar.gz" \
 && sed -i "${HOME}/rpmbuild/SPECS/libheimdal.spec" -e "/^Source0:/ s|.*|Source0: heimdal-7.8.0.tar.gz|" -e "/^Patch0/ s|^|#|" \
 && rpmbuild -bc ${HOME}/rpmbuild/SPECS/libheimdal.spec \
 && sudo make -C ${HOME}/rpmbuild/BUILD/heimdal-7.8.0/tools/ install
