/*
 * Remote Laboratory Sensor Monitor Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2014 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_FPGAPROGRAMPART_H
#define REMOTELAB_FPGAPROGRAMPART_H

#include <tdekrbclientsocket.h>

#include <tqcstring.h>
#include <tqframe.h>
#include <tqimage.h>
#include <tqdatetime.h>

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

#include <tqtrla.h>

#include "floatspinbox.h"

#define MAXTRACES 255

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQRectF;
class TQGridLayout;
class TQCheckBox;
class TQGroupBox;
class TQFile;
class TQLabel;
class TQPushButton;
class SensorMonitorBase;

namespace RemoteLab
{
	class Q_EXPORT TQValueTimer : public TQTimer
	{
		Q_OBJECT

		public:
			TQValueTimer(TQObject *parent=0, const char *name=0);
			~TQValueTimer();
			int value();
			void setValue(int);

		signals:
			void valueTimeout(int);

		private slots:
			void timeoutHandler();

		private:
			int m_value;
	};

	class TraceControlWidget : public TQWidget
	{
		Q_OBJECT

		public:
			TraceControlWidget(TQWidget *parent=0, const char *name=0);
			~TraceControlWidget();

		public:
			void setTraceEnabled(bool enabled);
			void setTraceName(TQString name);
			double timestep();
			void setTimestep(double seconds);
			void setMinTimestep(double seconds);
			void startSampleTimer(int msecs);
			void stopSampleTimer();
			void setCurrentSampleValue(double value, TQString units);
			void setCurrentSampleTimestamp(TQDateTime timestamp);

		signals:
			void enableChanged(bool enabled);
			void newSampleDesired();
			void clearTraceRequested();

		private slots:
			void enableClicked();
			void timestepChanged(double);
			void clearTraceDataClicked();

		private:
			TQGroupBox* m_groupBox;
			TQGridLayout* m_primaryLayout;
			TQCheckBox* m_channelEnabledCheckBox;
			FloatSpinBox* m_timestepSpinBox;
			TQTimer* m_sampleTimer;
			TQLabel* m_timestepLabel1;
			TQLabel* m_timestepLabel2;
			TQLabel* m_valueLabel;
			TQLabel* m_timestampLabel;
			TQPushButton* m_clearPushButton;

			double m_minimumTimeStep;
			double m_nominalTimeStep;
	};

	class SensorMonitorPart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			SensorMonitorPart(TQWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~SensorMonitorPart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		public slots:
			virtual bool openURL(const KURL &url);
			void updateZoomWidgetLimits(const TQRectF& zoomRect);
		
		private slots:
			void postInit();
			void resizeToHint();
			void mainEventLoop();
			void processLockouts();
			void connectionClosed();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);

			void updateGraticule();
			void updateTraceControlWidgets();
			void traceControlEnableChanged(bool enabled);
			void traceControlClearRequested();
			void processNewSampleRequest();
			void processNewSampleRequest(int channel);
			void processAutosave();
			void acquisitionStartButtonClicked();
			void acquisitionStopButtonClicked();
			void saveWaveforms();
			void saveWaveforms(TQString fileName);
			void recallWaveforms();
	
		private:
			SensorMonitorBase* m_base;
			TraceWidget* m_traceWidget;
			TQGridLayout* m_traceControlWidgetGrid;
			TQMutex* m_connectionMutex;
			TQTimer* m_pingDelayTimer;
			TQTimer* m_forcedUpdateTimer;
			TQTimer* m_updateTimeoutTimer;

			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerNextState;
			int m_commHandlerNextMode;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;

			bool stopTraceUpdate;
			SensorList m_sensorList;
			TQ_INT16 m_maxNumberOfTraces;
			TQ_INT16 m_hdivs;
			TQ_INT16 m_vdivs;
			TQ_INT32 m_samplesInTrace[MAXTRACES+1];
			bool m_channelActive[MAXTRACES+1];
			TQString m_traceUnits[MAXTRACES+1];
			TraceControlWidget* m_traceControlWidgetList[MAXTRACES];
			TQ_UINT32 m_sampleRequestIndex;
			bool m_sampleRequestInProgress[MAXTRACES+1];
	};
}

#endif
