/*
 * Remote Laboratory Seven Segment Display Widget
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012 - 2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_DISPLAY7SEGEMENT_H
#define REMOTELAB_DISPLAY7SEGEMENT_H

#include <tqframe.h>
#include <tqlayout.h>

class Display7SegmentPrivate;

class TQ_EXPORT Display7Segment : public TQFrame
{
	Q_OBJECT
	TQ_ENUMS(SegmentStyle)
	TQ_PROPERTY(SegmentStyle segmentStyle READ segmentStyle WRITE setSegmentStyle)

	public:
		Display7Segment(TQWidget* parent=0, const char* name=0);
		~Display7Segment();

		enum SegmentStyle { Outline, Filled, Flat };

		SegmentStyle segmentStyle() const;
		virtual void setSegmentStyle(SegmentStyle);

		void setLitSegments(unsigned char);
		static unsigned char segmentsForNumericDigit(unsigned char val, bool dp);

		TQSize sizeHint() const;

	protected:
		void drawContents(TQPainter *);

	private:
		void init();
		void drawSegment(const TQPoint &, char, TQPainter &, int, bool = FALSE);
		void drawDigit(const TQPoint &, TQPainter &, int, const char *);

		char* m_prevSegments;
		char* m_currentSegments;

		unsigned int prevSegments;
		double val;
		uint smallPoint	: 1;
		uint fill	: 1;
		uint shadow	: 1;
		Display7SegmentPrivate *d;
};

class TQ_EXPORT Display7SegmentArray : public TQFrame
{
	Q_OBJECT
	TQ_ENUMS(SegmentStyle)
	TQ_PROPERTY(SegmentStyle segmentStyle READ segmentStyle WRITE setSegmentStyle)

	public:
		Display7SegmentArray(TQWidget* parent=0, const char* name=0);
		~Display7SegmentArray();

		enum SegmentStyle { Outline, Filled, Flat };

		SegmentStyle segmentStyle() const;
		virtual void setSegmentStyle(SegmentStyle);

		void setNumberOfDigits(unsigned int count);

		void setValue(double value, int maxDecimalLength=-1, bool forceMinDecimalLength=false);

	protected:
		unsigned int m_numberOfDigits;
		Display7Segment** m_displayArray;
		TQGridLayout* m_layout;
		SegmentStyle m_segmentStyle;

	private:
		void init();
};

#endif