/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tqstringlist.h>
#include <tqlabel.h>
#include <tqmap.h>

#include <tdeapplication.h>
#include <ksimpleconfig.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <dcopclient.h>
#include <kprocess.h>
#include <kcombobox.h>
#include <tdemessagebox.h>

#include "selectserverdlg.h"
#include "selectserverdlgbase.h"

class Q_EXPORT StationTypeListViewItem : public TQListViewItem
{
	public:
		StationTypeListViewItem(TQListView * parent) : TQListViewItem(parent) {}
		StationTypeListViewItem(TQListViewItem * parent) : TQListViewItem(parent) {}
		StationTypeListViewItem(TQListView * parent, TQListViewItem * after) : TQListViewItem(parent, after) {}
		StationTypeListViewItem(TQListViewItem * parent, TQListViewItem * after) : TQListViewItem(parent, after) {}
		
		StationTypeListViewItem(TQListView * parent, TQString s1, TQString s2 = TQString::null, TQString s3 = TQString::null, TQString s4 = TQString::null, TQString s5 = TQString::null, TQString s6 = TQString::null, TQString s7 = TQString::null, TQString s8 = TQString::null) : TQListViewItem(parent, s1, s2, s3, s4, s5, s6, s7, s8) {}
		StationTypeListViewItem(TQListViewItem * parent, TQString s1, TQString s2 = TQString::null, TQString s3 = TQString::null, TQString s4 = TQString::null, TQString s5 = TQString::null, TQString s6 = TQString::null, TQString s7 = TQString::null, TQString s8 = TQString::null) : TQListViewItem(parent, s1, s2, s3, s4, s5, s6, s7, s8) {}
		
		StationTypeListViewItem(TQListView * parent, TQListViewItem * after, TQString s1, TQString s2 = TQString::null, TQString s3 = TQString::null, TQString s4 = TQString::null, TQString s5 = TQString::null, TQString s6 = TQString::null, TQString s7 = TQString::null, TQString s8 = TQString::null) : TQListViewItem(parent, after, s1, s2, s3, s4, s5, s6, s7, s8) {}
		StationTypeListViewItem(TQListViewItem * parent, TQListViewItem * after, TQString s1, TQString s2 = TQString::null, TQString s3 = TQString::null, TQString s4 = TQString::null, TQString s5 = TQString::null, TQString s6 = TQString::null, TQString s7 = TQString::null, TQString s8 = TQString::null) : TQListViewItem(parent, after, s1, s2, s3, s4, s5, s6, s7, s8) {}

		~StationTypeListViewItem() {}

	public:
		StationType m_stationType;
};

SelectServerDialog::SelectServerDialog(TQWidget* parent, const char* name, StationList sl)
	: KDialogBase(parent, name, true, i18n("Workspace Selection"), Ok|Cancel, Ok, true), m_stationList(sl)
{
	unsigned int i;
	unsigned int j;

	m_base = new SelectServerDlg(this);

	setMainWidget(m_base);

	m_base->serverList->setAllColumnsShowFocus(true);
	m_base->serverList->setFullWidth(true);

	connect(m_base->serverList, TQT_SIGNAL(executed(TQListViewItem*)), this, TQT_SLOT(slotOk()));

	for (i=0; i<m_stationList.count(); i++) {
		StationType st = m_stationList[i];
		TQString services;
		for (j=0; j<st.services.count(); j++) {
			ServiceType servicetype = st.services[j];
			if (j > 0) {
				services.append(", ");
			}
			services.append(servicetype.description);
		}
		bool newService = true;
		TQListViewItemIterator it(m_base->serverList);
		while (it.current()) {
			StationTypeListViewItem* curItem = dynamic_cast<StationTypeListViewItem*>(it.current());
			if (curItem) {
				if (curItem->m_stationType.services == st.services) {
					newService = false;
				}
				++it;
			}
		}
		if (newService) {
			StationTypeListViewItem* item = new StationTypeListViewItem(m_base->serverList, services);
			item->m_stationType = st;
		}
	}
}

void SelectServerDialog::slotOk() {
	StationTypeListViewItem* curItem = dynamic_cast<StationTypeListViewItem*>(m_base->serverList->selectedItem());

	if (!curItem) {
		KMessageBox::error(this, i18n("You must select a workstation type to continue!"), i18n("Input Required"));
		return;
	}

	m_selectedStation = curItem->m_stationType;

	accept();
}

#include "selectserverdlg.moc"
