/*
 * Remote Laboratory Administration Console Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_ADMINCONSOLEPART_H
#define REMOTELAB_ADMINCONSOLEPART_H

#include <tdekrbclientsocket.h>

#include <tqcstring.h>
#include <tqframe.h>
#include <tqimage.h>

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>
#include <kled.h>

#include <tqtrla.h>

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQFile;
class AdminConsoleBase;

namespace RemoteLab
{
	class AdminConsolePart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			AdminConsolePart(TQWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~AdminConsolePart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		public slots:
			virtual bool openURL(const KURL &url);
		
		private slots:
			void postInit();
			void resizeToHint();
			void mainEventLoop();
			void processLockouts();
			void connectionClosed();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);

			void terminalServiceKillButtonClicked();
			void workspaceTerminateButtonClicked();
			void workspaceCancelTerminationButtonClicked();

			void terminalServiceListSelect();
			void workspaceListSelect();
	
		private:
			AdminConsoleBase* m_base;
			TQMutex* m_connectionMutex;
			TQTimer* m_pingDelayTimer;
			TQTimer* m_forcedUpdateTimer;
			TQTimer* m_updateTimeoutTimer;

			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerNextState;
			int m_commHandlerNextMode;
			TQString terminateSessionID;
			TQ_INT32 terminateSessionDelayMinutes;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;
			TQByteArray m_programmingFileData;
			TQ_ULONG m_programmingFileTotalSize;
			TQ_ULONG m_programmingFileTransferredBytes;
	};
}

#endif
