/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _TERMINATEDIALOG_H_
#define _TERMINATEDIALOG_H_

#include <kdialogbase.h>
#include <kcombobox.h>

class TerminateDlgBase;
class TopLevel;

class TerminateDialog : public KDialogBase
{
	Q_OBJECT

public:
	TerminateDialog(TQWidget* parent = 0, const char* name = 0);

public slots:
	void slotOk();

public:
	void enableDelayedTermination(bool enabled);
	void setWarningLabelText(TQString text);
	bool delayed();
	int minutes();

private slots:
	void processLockouts();

private:
	TerminateDlgBase *m_base;
};

#endif
