/***************************************************************************
 *   Copyright (C) 2013 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _GROUPAUTHDIALOG_H_
#define _GROUPAUTHDIALOG_H_

#include <kdialogbase.h>
#include <kcombobox.h>

class GroupPermissionsDlgBase;
class TopLevel;

typedef TQPair< TQString, TQ_UINT32 > TQKeyedStringPair;
typedef TQValueList< TQKeyedStringPair > TQKeyedStringList;

class TQListBoxKeyedText : public TQListBoxText
{
	public:
		TQListBoxKeyedText(TQListBox* listbox, const TQString & text=TQString::null, const TQ_UINT32 key=0);
		TQListBoxKeyedText(const TQString & text=TQString::null, const TQ_UINT32 key=0 );
		TQListBoxKeyedText(TQListBox* listbox, const TQString & text, const TQ_UINT32 key, TQListBoxItem *after);
		~TQListBoxKeyedText();

	public:
		TQ_UINT32 key();

	private:
		TQ_UINT32 m_key;
};

class GroupPermissionsDialog : public KDialogBase
{
	Q_OBJECT

	public:
		GroupPermissionsDialog(TQWidget* parent = 0, const char* name = 0);
	
	public:
		void setGroupName(TQString name, bool editable);
		TQString groupName();
		void setPermissionsSelectorLabel(TQString label);
		void setAvailableServers(TQKeyedStringList list);
		void setSelectedServers(TQKeyedStringList list);
		TQKeyedStringList selectedServers();
		void setSessionLimit(int limit, bool visible);
		int sessionLimit();
	
	public slots:
		void slotOk();
	
	private slots:
		void processLockouts();
	
	private:
		GroupPermissionsDlgBase *m_base;
};

#endif
