/*
 * Remote Laboratory Serial Console Part
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2014 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#ifndef REMOTELAB_SERIALCONSOLEPART_H
#define REMOTELAB_SERIALCONSOLEPART_H

#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

#include <tqtrla.h>

class TDEAboutData;
using KParts::StatusBarExtension;
class TraceWidget;
class TQSocket;
class TQTimer;
class TQMutex;
class TQRectF;
class SerialConsoleBase;

namespace RemoteLab
{
	class SerialConsolePart : public KParts::RemoteInstrumentPart
	{
		Q_OBJECT
	
		public:
			SerialConsolePart( QWidget *, const char *, TQObject *, const char *, const TQStringList&);
			~SerialConsolePart();
	
			virtual bool openFile() { return false; }	// pure virtual in the base class
			virtual bool closeURL();
			static TDEAboutData *createAboutData();

		public slots:
			virtual bool openURL(const KURL &url);
		
		private slots:
			void postInit();
			void processLockouts();
			void connectionFinishedCallback();
			void disconnectFromServerCallback();
			void connectionStatusChangedCallback();
			void setTickerMessage(TQString message);
			void mainEventLoop();
			void sendTextClicked();
	
		private:
			int m_commHandlerState;
			int m_commHandlerMode;
			int m_commHandlerCommandState;
			TQTimer* m_forcedUpdateTimer;
			TQTimer* m_updateTimeoutTimer;
			bool m_connectionActiveAndValid;
			unsigned char m_tickerState;
			SerialConsoleBase* m_base;
			TQMutex* m_instrumentMutex;
			TQString m_TextToSend;
	};
}

#endif
