/*
 * Floating-point SpinBox Widget
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 *
 * Original Author: Ewald R. de Wit
 * From Qt-Interest mailing list
 * http://lists.trolltech.com/qt-interest/1999-07/thread00400-0.html
 */

#ifndef FLOATSPINBOX_H
#define FLOATSPINBOX_H

#include <tqstring.h>
#include <tqspinbox.h>

class FloatSpinBox : public TQSpinBox
{
	Q_OBJECT

	public:
		FloatSpinBox(TQWidget *parent = 0, const char* name = 0);
		FloatSpinBox(double min, double max, double value, TQWidget *parent = 0);
		~FloatSpinBox();

		void init(double min, double max, double value, int precision=-1);
		void setFloatMin(double min);
		void setFloatMax(double max);
		void setPrecision(int precision);

		double floatValue();

	private:
		int dec;
		virtual TQString mapValueToText(int value);
		virtual int mapTextToValue(bool * ok);

	public slots:
		void setFloatValue(double d);
		virtual void setEnabled(bool);

	private slots:
		void acceptValueChanged(int value);

	signals:
		void floatValueChanged(double value);

	private:
		double min;
		double max;
		double value;
};

#endif // FLOATSPINBOX_H