/*
 * Remote Laboratory FPGA Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <tqsocket.h>
#include <tqserversocket.h>
#include <tqapplication.h>
#include <tqvbox.h>
#include <tqtextview.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>
#include <tqsqldatabase.h>
#include <tqsqlcursor.h>

#include <ksimpleconfig.h>

#include <tdekrbserversocket.h>

#include <tqtrla.h>

#define MAGIC_NUMBER 1
#define PROTOCOL_VERSION 1

class SysCtlSocket : public TDEKerberosServerSocket
{
	Q_OBJECT

	public:
		SysCtlSocket(int sock, TQObject *parent=0, const char *name=0);
		~SysCtlSocket();

	public:
		void close();
		void initiateKerberosHandshake();
		int enterCommandLoop();

	private slots:
		void finishKerberosHandshake();
		void connectionClosedHandler();
		void commandLoop();
		int connectToDatabase();
	
	private:
		int line;
		int m_criticalSection;
		TQString m_remoteHost;

		TQTimer* m_kerberosInitTimer;
		TQTimer* m_loopTimer;
		TQTimer* m_servClientTimeout;

		KSimpleConfig* m_config;
		TQSqlDatabase* m_terminals_database;
		TQSqlDatabase* m_workspaces_database;
		int m_commandLoopState;

		friend class SysCtlServer;
};

class SysCtlServer : public TQServerSocket
{
	Q_OBJECT

	public:
		SysCtlServer(TQObject* parent=0, int port=0, KSimpleConfig* config=0);
		~SysCtlServer();
	
		void newConnection(int socket);

	private slots:
		void remoteConnectionClosed();
		int connectToDatabase();
		void pingSQLServer();
	
	signals:
		void newConnect(SysCtlSocket*);

	private:
		KSimpleConfig* m_config;
		int m_numberOfConnections;
		TQSqlDatabase* m_terminals_database;
		TQSqlDatabase* m_workspaces_database;
		TQTimer* m_sqlPingTimer;

		friend class SysCtlSocket;

};