/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <pwd.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <tqdatetime.h>
#include <tqfile.h>
#include <tqdir.h>

#include <tdeapplication.h>
#include <tdestartupinfo.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <ksimpleconfig.h>

#include "fpga_conn.h"

static const char description[] = I18N_NOOP("uLab FPGA Viewer Server");

static const char version[] = "v0.0.1";

int main(int argc, char *argv[])
{
	TDEAboutData aboutData( "ulab_fpga_server", I18N_NOOP("uLab FPGA Viewer Server"),
		version, description, TDEAboutData::License_GPL,
		"(c) 2012, Timothy Pearson");
		aboutData.addAuthor("Timothy Pearson",0, "kb9vqf@pearsoncomputing.net");
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDEApplication::disableAutoDcopRegistration();

	TDEApplication app(false, false);

	TDEStartupInfo::appStarted();

	KSimpleConfig config(TQDir::currentDirPath() + "/ulab_fpgaserver.conf", false);
	config.setGroup("Server");
	FPGAServer fpgasvr(0, config.readNumEntry("port", 4010), &config);
	return app.exec();

}
