/*
 * Remote Laboratory Instrumentation Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2009 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

extern unsigned char scope_raw_screenshot_data[4194304];
extern double scope_raw_trace_data[65535];
extern double scope_raw_position_data[65535];

unsigned long scopeScreenSize (const char * scopeType);
unsigned long scopeScreenWidth (const char * scopeType);
unsigned long scopeScreenHeight (const char * scopeType);
int gpib_read_binary(int ud, int max_num_bytes);
int scope_reset(const char * funcgenType, int gpibDevice);
int scope_get_screenshot(const char * scopeType, int gpibDevice);
int scope_get_screenshot_stage2(const char * scopeType, int gpibDevice);
int scope_perform_initial_setup(const char * scopeType, int gpibDevice);
int scope_set_timebase(float desired_timebase,const char * scopeType, int gpibDevice);
int scope_get_timebase(double * retval, const char * scopeType, int gpibDevice);
int scope_set_volts_div(int desired_channel, double desired_volts, const char * scopeType, int gpibDevice);
int scope_set_acquisition(int status,const char * scopeType, int gpibDevice);
int scope_get_acquisition(int * retval, const char * scopeType, int gpibDevice);
int scope_set_channel_state(int desired_channel, int status, const char * scopeType, int gpibDevice);
int scope_get_channel_state(int * retval, int desired_channel, const char * scopeType, int gpibDevice);
int scope_set_trigger_channel(int desired_channel,const char * scopeType, int gpibDevice);
int scope_set_trigger_level(float desired_level,const char * scopeType, int gpibDevice);
int scope_set_channel_position(int desired_channel, float desired_level,const char * scopeType, int gpibDevice);
long scope_get_channel_trace(int desired_channel, const char * scopeType, int gpibDevice);
int scope_get_number_of_horizontal_divisions(const char * scopeType, int gpibDevice);
int scope_get_number_of_vertical_divisions(const char * scopeType, int gpibDevice);
int scope_get_number_of_channels(const char * scopeType, int gpibDevice);
int scope_get_trigger_channel(int * retval, const char * scopeType, int gpibDevice);
int scope_get_trigger_level(double * retval, const char * scopeType, int gpibDevice);
int scope_get_channel_volts_div(double * retval, int desired_channel, const char * scopeType, int gpibDevice);
int scope_get_channel_seconds_div(double * retval, int desired_channel, const char * scopeType, int gpibDevice);
int scope_get_channel_sample_count(unsigned long * retval, int desired_channel, const char * scopeType, int gpibDevice);
int scope_get_probe_attenuation_multiplier(double * retval, int desired_channel, const char * scopeType, int gpibDevice);
int scope_get_permitted_volts_div_settings_at_1x(int * number_of_values, double ** retarray, const char * scopeType, int gpibDevice);
int scope_get_permitted_seconds_div_settings(int * number_of_values, double ** retarray, const char * scopeType, int gpibDevice);