static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * This operation is inspired from the color enhance gimp plugin.             \n"
" * It alters the chroma component to cover maximum possible range,            \n"
" * keeping hue and lightness untouched.                                       \n"
" *                                                                            \n"
" * Thomas Manni <thomas.manni@free.fr>                                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE color-enhance.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"buffer_get_min_max (GeglBuffer *buffer,                                       \n"
"                    gdouble    *min,                                          \n"
"                    gdouble    *max)                                          \n"
"{                                                                             \n"
"  GeglBufferIterator *gi;                                                     \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (buffer, NULL, 0, babl_format (\"CIE LCH(ab) float\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  *min = G_MAXDOUBLE;                                                         \n"
"  *max = -G_MAXDOUBLE;                                                        \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gint o;                                                                 \n"
"      gfloat *buf = gi->data[0];                                              \n"
"                                                                              \n"
"      for (o = 0; o < gi->length; o++)                                        \n"
"        {                                                                     \n"
"          *min = MIN (buf[1], *min);                                          \n"
"          *max = MAX (buf[1], *max);                                          \n"
"          buf += 3;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format;                                                         \n"
"  const Babl *in_format = gegl_operation_get_source_format (operation, \"input\");\n"
"                                                                              \n"
"  if (in_format)                                                              \n"
"    {                                                                         \n"
"       if (babl_format_has_alpha (in_format))                                 \n"
"         format = babl_format (\"CIE LCH(ab) alpha float\");                  \n"
"       else                                                                   \n"
"         format = babl_format (\"CIE LCH(ab) float\");                        \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      format = babl_format (\"CIE LCH(ab) float\");                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  const Babl *format = gegl_operation_get_format (operation, \"output\");     \n"
"  gboolean has_alpha = babl_format_has_alpha (format);                        \n"
"  GeglBufferIterator *gi;                                                     \n"
"  gdouble  min;                                                               \n"
"  gdouble  max;                                                               \n"
"  gdouble  delta;                                                             \n"
"                                                                              \n"
"  buffer_get_min_max (input, &min, &max);                                     \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (input, result, 0, format,                    \n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (gi, output, result, 0, format,                    \n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  delta = max - min;                                                          \n"
"                                                                              \n"
"  if (! delta)                                                                \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, NULL, GEGL_ABYSS_NONE,                         \n"
"                        output, NULL);                                        \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (has_alpha)                                                              \n"
"    {                                                                         \n"
"      while (gegl_buffer_iterator_next (gi))                                  \n"
"        {                                                                     \n"
"          gfloat *in  = gi->data[0];                                          \n"
"          gfloat *out = gi->data[1];                                          \n"
"                                                                              \n"
"          gint i;                                                             \n"
"          for (i = 0; i < gi->length; i++)                                    \n"
"            {                                                                 \n"
"              out[0] = in[0];                                                 \n"
"              out[1] = (in[1] - min) / delta * 100.0;                         \n"
"              out[2] = in[2];                                                 \n"
"              out[3] = in[3];                                                 \n"
"                                                                              \n"
"              in  += 4;                                                       \n"
"              out += 4;                                                       \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"       while (gegl_buffer_iterator_next (gi))                                 \n"
"        {                                                                     \n"
"          gfloat *in  = gi->data[0];                                          \n"
"          gfloat *out = gi->data[1];                                          \n"
"                                                                              \n"
"          gint i;                                                             \n"
"          for (i = 0; i < gi->length; i++)                                    \n"
"            {                                                                 \n"
"              out[0] = in[0];                                                 \n"
"              out[1] = (in[1] - min) / delta * 100.0;                         \n"
"              out[2] = in[2];                                                 \n"
"                                                                              \n"
"              in  += 3;                                                       \n"
"              out += 3;                                                       \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/* Pass-through when trying to perform a reduction on an infinite plane       \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"                                                                              \n"
"  const GeglRectangle *in_rect =                                              \n"
"    gegl_operation_source_get_bounding_box (operation, \"input\");            \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (in_rect && gegl_rectangle_is_infinite_plane (in_rect))                  \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color-enhance\",                                  \n"
"    \"title\",       _(\"Color Enhance\"),                                    \n"
"    \"categories\" , \"color:enhance\",                                       \n"
"    \"description\",                                                          \n"
"        _(\"Stretch color chroma to cover maximum possible range, \"          \n"
"          \"keeping hue and lightness untouched.\"),                          \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
