/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Instrumentor;
import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.instrumentor.ChainInstrumentor;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiMethod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class InstrumentorChain
implements Instrumentor {
    private Instrumentation instrumentation = new Instrumentation();
    private static Category log = Runtime.getLogCategory(InstrumentorChain.class);
    private JiapiClass currentClass;
    private List instrumentors = new ArrayList();

    public void add(ChainInstrumentor instrumentor) {
        if (this.instrumentors.size() > 0) {
            AbstractInstrumentor parent = (AbstractInstrumentor)this.instrumentors.get(this.instrumentors.size() - 1);
            parent.setChild((AbstractInstrumentor)instrumentor);
        }
        this.instrumentors.add(instrumentor);
    }

    public JiapiClass getCurrentClass() {
        return this.currentClass;
    }

    public void instrument(JiapiClass clazz) {
        this.currentClass = clazz;
        JiapiMethod[] methods = clazz.getDeclaredMethods();
        AbstractInstrumentor instr = (AbstractInstrumentor)this.instrumentors.get(0);
        log.info((Object)("Bootstrapping instrumentation of " + clazz.getName() + " to " + this));
        instr.setCurrentClass(clazz);
        instr.instrument(null, this.instrumentation);
        log.info((Object)("Instrumentation of " + clazz.getName() + " is finished with " + this));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        Iterator iter = this.instrumentors.iterator();
        while (iter.hasNext()) {
            ChainInstrumentor i = (ChainInstrumentor)iter.next();
            sb.append(i.toString());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    Instrumentation getInstrumentation() {
        return this.instrumentation;
    }
}

