/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <libwpd-stream/libwpd-stream.h>

#include "PDXLZ77Stream.h"

#include "PDXLZ77StreamTest.h"

using libebook::PDXLZ77Stream;

namespace test
{

void PDXLZ77StreamTest::setUp()
{
}

void PDXLZ77StreamTest::tearDown()
{
}

void PDXLZ77StreamTest::testRead()
{
  const unsigned char unpacked[] = "abc dee abc";
  const unsigned char data[] = "\x61\x62\x01\x63\xe4\x02\x65\x65\x20\x80\x40";
  WPXStringStream dataStream(data, sizeof(data));
  PDXLZ77Stream stream(&dataStream);

  CPPUNIT_ASSERT_MESSAGE("stream is already exhausted before starting to read", !stream.atEOS());

  for (int i = 0; sizeof(unpacked) != i; ++i)
  {
    unsigned long readBytes = 0;
    const unsigned char *s = stream.read(1, readBytes);

    CPPUNIT_ASSERT(1 == readBytes);
    CPPUNIT_ASSERT_EQUAL(unpacked[i], s[0]);
    CPPUNIT_ASSERT(((sizeof(unpacked) - 1) == i) || !stream.atEOS());
  }

  CPPUNIT_ASSERT_MESSAGE("reading did not exhaust the stream", stream.atEOS());
}

CPPUNIT_TEST_SUITE_REGISTRATION(PDXLZ77StreamTest);

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
